package iqs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CommonQueryByScene invokes the iqs.CommonQueryByScene API synchronously
func (client *Client) CommonQueryByScene(request *CommonQueryBySceneRequest) (response *CommonQueryBySceneResponse, err error) {
	response = CreateCommonQueryBySceneResponse()
	err = client.DoAction(request, response)
	return
}

// CommonQueryBySceneWithChan invokes the iqs.CommonQueryByScene API asynchronously
func (client *Client) CommonQueryBySceneWithChan(request *CommonQueryBySceneRequest) (<-chan *CommonQueryBySceneResponse, <-chan error) {
	responseChan := make(chan *CommonQueryBySceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CommonQueryByScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CommonQueryBySceneWithCallback invokes the iqs.CommonQueryByScene API asynchronously
func (client *Client) CommonQueryBySceneWithCallback(request *CommonQueryBySceneRequest, callback func(response *CommonQueryBySceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CommonQueryBySceneResponse
		var err error
		defer close(result)
		response, err = client.CommonQueryByScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CommonQueryBySceneRequest is the request struct for api CommonQueryByScene
type CommonQueryBySceneRequest struct {
	*requests.RoaRequest
}

// CommonQueryBySceneResponse is the response struct for api CommonQueryByScene
type CommonQueryBySceneResponse struct {
	*responses.BaseResponse
	Data []DataItem `json:"data" xml:"data"`
}

// CreateCommonQueryBySceneRequest creates a request to invoke CommonQueryByScene API
func CreateCommonQueryBySceneRequest() (request *CommonQueryBySceneRequest) {
	request = &CommonQueryBySceneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("IQS", "2024-07-12", "CommonQueryByScene", "/amap-function-call-agent/iqs-agent-service/v2/nl/common", "", "")
	request.Method = requests.POST
	return
}

// CreateCommonQueryBySceneResponse creates a response to parse from CommonQueryByScene response
func CreateCommonQueryBySceneResponse() (response *CommonQueryBySceneResponse) {
	response = &CommonQueryBySceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
