package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateOTAModule invokes the iot.UpdateOTAModule API synchronously
func (client *Client) UpdateOTAModule(request *UpdateOTAModuleRequest) (response *UpdateOTAModuleResponse, err error) {
	response = CreateUpdateOTAModuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateOTAModuleWithChan invokes the iot.UpdateOTAModule API asynchronously
func (client *Client) UpdateOTAModuleWithChan(request *UpdateOTAModuleRequest) (<-chan *UpdateOTAModuleResponse, <-chan error) {
	responseChan := make(chan *UpdateOTAModuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateOTAModule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateOTAModuleWithCallback invokes the iot.UpdateOTAModule API asynchronously
func (client *Client) UpdateOTAModuleWithCallback(request *UpdateOTAModuleRequest, callback func(response *UpdateOTAModuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateOTAModuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateOTAModule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateOTAModuleRequest is the request struct for api UpdateOTAModule
type UpdateOTAModuleRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ModuleName    string `position:"Query" name:"ModuleName"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	AliasName     string `position:"Query" name:"AliasName"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	Desc          string `position:"Query" name:"Desc"`
}

// UpdateOTAModuleResponse is the response struct for api UpdateOTAModule
type UpdateOTAModuleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateOTAModuleRequest creates a request to invoke UpdateOTAModule API
func CreateUpdateOTAModuleRequest() (request *UpdateOTAModuleRequest) {
	request = &UpdateOTAModuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateOTAModule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateOTAModuleResponse creates a response to parse from UpdateOTAModule response
func CreateUpdateOTAModuleResponse() (response *UpdateOTAModuleResponse) {
	response = &UpdateOTAModuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
