package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListParserDataSource invokes the iot.ListParserDataSource API synchronously
func (client *Client) ListParserDataSource(request *ListParserDataSourceRequest) (response *ListParserDataSourceResponse, err error) {
	response = CreateListParserDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListParserDataSourceWithChan invokes the iot.ListParserDataSource API asynchronously
func (client *Client) ListParserDataSourceWithChan(request *ListParserDataSourceRequest) (<-chan *ListParserDataSourceResponse, <-chan error) {
	responseChan := make(chan *ListParserDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListParserDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListParserDataSourceWithCallback invokes the iot.ListParserDataSource API asynchronously
func (client *Client) ListParserDataSourceWithCallback(request *ListParserDataSourceRequest, callback func(response *ListParserDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListParserDataSourceResponse
		var err error
		defer close(result)
		response, err = client.ListParserDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListParserDataSourceRequest is the request struct for api ListParserDataSource
type ListParserDataSourceRequest struct {
	*requests.RpcRequest
	SearchName    string           `position:"Query" name:"SearchName"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	Page          requests.Integer `position:"Query" name:"Page"`
}

// ListParserDataSourceResponse is the response struct for api ListParserDataSource
type ListParserDataSourceResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	Success      bool                       `json:"Success" xml:"Success"`
	Code         string                     `json:"Code" xml:"Code"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Page         int                        `json:"Page" xml:"Page"`
	PageSize     int                        `json:"PageSize" xml:"PageSize"`
	Total        int                        `json:"Total" xml:"Total"`
	Data         DataInListParserDataSource `json:"Data" xml:"Data"`
}

// CreateListParserDataSourceRequest creates a request to invoke ListParserDataSource API
func CreateListParserDataSourceRequest() (request *ListParserDataSourceRequest) {
	request = &ListParserDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListParserDataSource", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListParserDataSourceResponse creates a response to parse from ListParserDataSource response
func CreateListParserDataSourceResponse() (response *ListParserDataSourceResponse) {
	response = &ListParserDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
