package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateParserDataSource invokes the iot.CreateParserDataSource API synchronously
func (client *Client) CreateParserDataSource(request *CreateParserDataSourceRequest) (response *CreateParserDataSourceResponse, err error) {
	response = CreateCreateParserDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateParserDataSourceWithChan invokes the iot.CreateParserDataSource API asynchronously
func (client *Client) CreateParserDataSourceWithChan(request *CreateParserDataSourceRequest) (<-chan *CreateParserDataSourceResponse, <-chan error) {
	responseChan := make(chan *CreateParserDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateParserDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateParserDataSourceWithCallback invokes the iot.CreateParserDataSource API asynchronously
func (client *Client) CreateParserDataSourceWithCallback(request *CreateParserDataSourceRequest, callback func(response *CreateParserDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateParserDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateParserDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateParserDataSourceRequest is the request struct for api CreateParserDataSource
type CreateParserDataSourceRequest struct {
	*requests.RpcRequest
	Description   string `position:"Query" name:"Description"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	Name          string `position:"Query" name:"Name"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// CreateParserDataSourceResponse is the response struct for api CreateParserDataSource
type CreateParserDataSourceResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Success      bool       `json:"Success" xml:"Success"`
	Code         string     `json:"Code" xml:"Code"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	DataSource   DataSource `json:"DataSource" xml:"DataSource"`
}

// CreateCreateParserDataSourceRequest creates a request to invoke CreateParserDataSource API
func CreateCreateParserDataSourceRequest() (request *CreateParserDataSourceRequest) {
	request = &CreateParserDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateParserDataSource", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateParserDataSourceResponse creates a response to parse from CreateParserDataSource response
func CreateCreateParserDataSourceResponse() (response *CreateParserDataSourceResponse) {
	response = &CreateParserDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
