package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeHandGesture invokes the facebody.RecognizeHandGesture API synchronously
func (client *Client) RecognizeHandGesture(request *RecognizeHandGestureRequest) (response *RecognizeHandGestureResponse, err error) {
	response = CreateRecognizeHandGestureResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeHandGestureWithChan invokes the facebody.RecognizeHandGesture API asynchronously
func (client *Client) RecognizeHandGestureWithChan(request *RecognizeHandGestureRequest) (<-chan *RecognizeHandGestureResponse, <-chan error) {
	responseChan := make(chan *RecognizeHandGestureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeHandGesture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeHandGestureWithCallback invokes the facebody.RecognizeHandGesture API asynchronously
func (client *Client) RecognizeHandGestureWithCallback(request *RecognizeHandGestureRequest, callback func(response *RecognizeHandGestureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeHandGestureResponse
		var err error
		defer close(result)
		response, err = client.RecognizeHandGesture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeHandGestureRequest is the request struct for api RecognizeHandGesture
type RecognizeHandGestureRequest struct {
	*requests.RpcRequest
	GestureType        string           `position:"Body" name:"GestureType"`
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	AppId              string           `position:"Body" name:"AppId"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// RecognizeHandGestureResponse is the response struct for api RecognizeHandGesture
type RecognizeHandGestureResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Code      string                     `json:"Code" xml:"Code"`
	Message   string                     `json:"Message" xml:"Message"`
	Data      DataInRecognizeHandGesture `json:"Data" xml:"Data"`
}

// CreateRecognizeHandGestureRequest creates a request to invoke RecognizeHandGesture API
func CreateRecognizeHandGestureRequest() (request *RecognizeHandGestureRequest) {
	request = &RecognizeHandGestureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "RecognizeHandGesture", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeHandGestureResponse creates a response to parse from RecognizeHandGesture response
func CreateRecognizeHandGestureResponse() (response *RecognizeHandGestureResponse) {
	response = &RecognizeHandGestureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
