package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEventBuses invokes the eventbridge.ListEventBuses API synchronously
func (client *Client) ListEventBuses(request *ListEventBusesRequest) (response *ListEventBusesResponse, err error) {
	response = CreateListEventBusesResponse()
	err = client.DoAction(request, response)
	return
}

// ListEventBusesWithChan invokes the eventbridge.ListEventBuses API asynchronously
func (client *Client) ListEventBusesWithChan(request *ListEventBusesRequest) (<-chan *ListEventBusesResponse, <-chan error) {
	responseChan := make(chan *ListEventBusesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEventBuses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEventBusesWithCallback invokes the eventbridge.ListEventBuses API asynchronously
func (client *Client) ListEventBusesWithCallback(request *ListEventBusesRequest, callback func(response *ListEventBusesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEventBusesResponse
		var err error
		defer close(result)
		response, err = client.ListEventBuses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEventBusesRequest is the request struct for api ListEventBuses
type ListEventBusesRequest struct {
	*requests.RpcRequest
	NextToken    string           `position:"Query" name:"NextToken"`
	Limit        requests.Integer `position:"Query" name:"Limit"`
	NamePrefix   string           `position:"Query" name:"NamePrefix"`
	EventBusType string           `position:"Query" name:"EventBusType"`
}

// ListEventBusesResponse is the response struct for api ListEventBuses
type ListEventBusesResponse struct {
	*responses.BaseResponse
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Code      string               `json:"Code" xml:"Code"`
	Success   bool                 `json:"Success" xml:"Success"`
	Data      DataInListEventBuses `json:"Data" xml:"Data"`
}

// CreateListEventBusesRequest creates a request to invoke ListEventBuses API
func CreateListEventBusesRequest() (request *ListEventBusesRequest) {
	request = &ListEventBusesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "ListEventBuses", "", "")
	request.Method = requests.POST
	return
}

// CreateListEventBusesResponse creates a response to parse from ListEventBuses response
func CreateListEventBusesResponse() (response *ListEventBusesResponse) {
	response = &ListEventBusesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
