package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApiDestination invokes the eventbridge.GetApiDestination API synchronously
func (client *Client) GetApiDestination(request *GetApiDestinationRequest) (response *GetApiDestinationResponse, err error) {
	response = CreateGetApiDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// GetApiDestinationWithChan invokes the eventbridge.GetApiDestination API asynchronously
func (client *Client) GetApiDestinationWithChan(request *GetApiDestinationRequest) (<-chan *GetApiDestinationResponse, <-chan error) {
	responseChan := make(chan *GetApiDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApiDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApiDestinationWithCallback invokes the eventbridge.GetApiDestination API asynchronously
func (client *Client) GetApiDestinationWithCallback(request *GetApiDestinationRequest, callback func(response *GetApiDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApiDestinationResponse
		var err error
		defer close(result)
		response, err = client.GetApiDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApiDestinationRequest is the request struct for api GetApiDestination
type GetApiDestinationRequest struct {
	*requests.RpcRequest
	ClientToken        string `position:"Query" name:"ClientToken"`
	ApiDestinationName string `position:"Query" name:"ApiDestinationName"`
}

// GetApiDestinationResponse is the response struct for api GetApiDestination
type GetApiDestinationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetApiDestinationRequest creates a request to invoke GetApiDestination API
func CreateGetApiDestinationRequest() (request *GetApiDestinationRequest) {
	request = &GetApiDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "GetApiDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateGetApiDestinationResponse creates a response to parse from GetApiDestination response
func CreateGetApiDestinationResponse() (response *GetApiDestinationResponse) {
	response = &GetApiDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
