package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEventSource invokes the eventbridge.CreateEventSource API synchronously
func (client *Client) CreateEventSource(request *CreateEventSourceRequest) (response *CreateEventSourceResponse, err error) {
	response = CreateCreateEventSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEventSourceWithChan invokes the eventbridge.CreateEventSource API asynchronously
func (client *Client) CreateEventSourceWithChan(request *CreateEventSourceRequest) (<-chan *CreateEventSourceResponse, <-chan error) {
	responseChan := make(chan *CreateEventSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEventSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEventSourceWithCallback invokes the eventbridge.CreateEventSource API asynchronously
func (client *Client) CreateEventSourceWithCallback(request *CreateEventSourceRequest, callback func(response *CreateEventSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEventSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateEventSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEventSourceRequest is the request struct for api CreateEventSource
type CreateEventSourceRequest struct {
	*requests.RpcRequest
	Description                    string                                          `position:"Body" name:"Description"`
	EventBusName                   string                                          `position:"Body" name:"EventBusName"`
	SourceMNSParameters            CreateEventSourceSourceMNSParameters            `position:"Body" name:"SourceMNSParameters"  type:"Struct"`
	LinkedExternalSource           requests.Boolean                                `position:"Body" name:"LinkedExternalSource"`
	ExternalSourceType             string                                          `position:"Body" name:"ExternalSourceType"`
	ExternalSourceConfig           string                                          `position:"Body" name:"ExternalSourceConfig"`
	SourceRabbitMQParameters       CreateEventSourceSourceRabbitMQParameters       `position:"Body" name:"SourceRabbitMQParameters"  type:"Struct"`
	SourceRocketMQParameters       CreateEventSourceSourceRocketMQParameters       `position:"Body" name:"SourceRocketMQParameters"  type:"Struct"`
	SourceSLSParameters            CreateEventSourceSourceSLSParameters            `position:"Body" name:"SourceSLSParameters"  type:"Struct"`
	SourceScheduledEventParameters CreateEventSourceSourceScheduledEventParameters `position:"Body" name:"SourceScheduledEventParameters"  type:"Struct"`
	SourceKafkaParameters          CreateEventSourceSourceKafkaParameters          `position:"Body" name:"SourceKafkaParameters"  type:"Struct"`
	SourceHttpEventParameters      CreateEventSourceSourceHttpEventParameters      `position:"Body" name:"SourceHttpEventParameters"  type:"Struct"`
	EventSourceName                string                                          `position:"Body" name:"EventSourceName"`
}

// CreateEventSourceSourceMNSParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceMNSParameters struct {
	QueueName      string `name:"QueueName"`
	RegionId       string `name:"RegionId"`
	IsBase64Decode string `name:"IsBase64Decode"`
}

// CreateEventSourceSourceRabbitMQParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceRabbitMQParameters struct {
	QueueName       string `name:"QueueName"`
	VirtualHostName string `name:"VirtualHostName"`
	InstanceId      string `name:"InstanceId"`
	RegionId        string `name:"RegionId"`
}

// CreateEventSourceSourceRocketMQParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceRocketMQParameters struct {
	InstanceSecurityGroupId string `name:"InstanceSecurityGroupId"`
	Offset                  string `name:"Offset"`
	GroupID                 string `name:"GroupID"`
	InstanceUsername        string `name:"InstanceUsername"`
	AuthType                string `name:"AuthType"`
	InstancePassword        string `name:"InstancePassword"`
	InstanceNetwork         string `name:"InstanceNetwork"`
	InstanceVSwitchIds      string `name:"InstanceVSwitchIds"`
	InstanceId              string `name:"InstanceId"`
	InstanceVpcId           string `name:"InstanceVpcId"`
	InstanceEndpoint        string `name:"InstanceEndpoint"`
	RegionId                string `name:"RegionId"`
	Topic                   string `name:"Topic"`
	InstanceType            string `name:"InstanceType"`
	Tag                     string `name:"Tag"`
	Timestamp               string `name:"Timestamp"`
}

// CreateEventSourceSourceSLSParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceSLSParameters struct {
	RoleName        string `name:"RoleName"`
	Project         string `name:"Project"`
	LogStore        string `name:"LogStore"`
	ConsumePosition string `name:"ConsumePosition"`
}

// CreateEventSourceSourceScheduledEventParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceScheduledEventParameters struct {
	Schedule string `name:"Schedule"`
	UserData string `name:"UserData"`
	TimeZone string `name:"TimeZone"`
}

// CreateEventSourceSourceKafkaParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceKafkaParameters struct {
	InstanceId      string `name:"InstanceId"`
	ConsumerGroup   string `name:"ConsumerGroup"`
	RegionId        string `name:"RegionId"`
	VSwitchIds      string `name:"VSwitchIds"`
	VpcId           string `name:"VpcId"`
	SecurityGroupId string `name:"SecurityGroupId"`
	Topic           string `name:"Topic"`
	OffsetReset     string `name:"OffsetReset"`
	MaximumTasks    string `name:"MaximumTasks"`
	Network         string `name:"Network"`
}

// CreateEventSourceSourceHttpEventParameters is a repeated param struct in CreateEventSourceRequest
type CreateEventSourceSourceHttpEventParameters struct {
	Referer        *[]string `name:"Referer" type:"Repeated"`
	Method         *[]string `name:"Method" type:"Repeated"`
	Ip             *[]string `name:"Ip" type:"Repeated"`
	SecurityConfig string    `name:"SecurityConfig"`
	Type           string    `name:"Type"`
}

// CreateEventSourceResponse is the response struct for api CreateEventSource
type CreateEventSourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateEventSourceRequest creates a request to invoke CreateEventSource API
func CreateCreateEventSourceRequest() (request *CreateEventSourceRequest) {
	request = &CreateEventSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "CreateEventSource", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateEventSourceResponse creates a response to parse from CreateEventSource response
func CreateCreateEventSourceResponse() (response *CreateEventSourceResponse) {
	response = &CreateEventSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
