package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopInstance invokes the ens.StopInstance API synchronously
func (client *Client) StopInstance(request *StopInstanceRequest) (response *StopInstanceResponse, err error) {
	response = CreateStopInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StopInstanceWithChan invokes the ens.StopInstance API asynchronously
func (client *Client) StopInstanceWithChan(request *StopInstanceRequest) (<-chan *StopInstanceResponse, <-chan error) {
	responseChan := make(chan *StopInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopInstanceWithCallback invokes the ens.StopInstance API asynchronously
func (client *Client) StopInstanceWithCallback(request *StopInstanceRequest, callback func(response *StopInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopInstanceResponse
		var err error
		defer close(result)
		response, err = client.StopInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopInstanceRequest is the request struct for api StopInstance
type StopInstanceRequest struct {
	*requests.RpcRequest
	ForceStop  string `position:"Query" name:"ForceStop"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// StopInstanceResponse is the response struct for api StopInstance
type StopInstanceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopInstanceRequest creates a request to invoke StopInstance API
func CreateStopInstanceRequest() (request *StopInstanceRequest) {
	request = &StopInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "StopInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopInstanceResponse creates a response to parse from StopInstance response
func CreateStopInstanceResponse() (response *StopInstanceResponse) {
	response = &StopInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
