package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExportImageInfo invokes the ens.DescribeExportImageInfo API synchronously
func (client *Client) DescribeExportImageInfo(request *DescribeExportImageInfoRequest) (response *DescribeExportImageInfoResponse, err error) {
	response = CreateDescribeExportImageInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExportImageInfoWithChan invokes the ens.DescribeExportImageInfo API asynchronously
func (client *Client) DescribeExportImageInfoWithChan(request *DescribeExportImageInfoRequest) (<-chan *DescribeExportImageInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeExportImageInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExportImageInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExportImageInfoWithCallback invokes the ens.DescribeExportImageInfo API asynchronously
func (client *Client) DescribeExportImageInfoWithCallback(request *DescribeExportImageInfoRequest, callback func(response *DescribeExportImageInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExportImageInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeExportImageInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExportImageInfoRequest is the request struct for api DescribeExportImageInfo
type DescribeExportImageInfoRequest struct {
	*requests.RpcRequest
	ImageId    string           `position:"Query" name:"ImageId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	ImageName  string           `position:"Query" name:"ImageName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeExportImageInfoResponse is the response struct for api DescribeExportImageInfo
type DescribeExportImageInfoResponse struct {
	*responses.BaseResponse
	PageNumber int                             `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                             `json:"PageSize" xml:"PageSize"`
	RequestId  string                          `json:"RequestId" xml:"RequestId"`
	TotalCount int                             `json:"TotalCount" xml:"TotalCount"`
	Images     ImagesInDescribeExportImageInfo `json:"Images" xml:"Images"`
}

// CreateDescribeExportImageInfoRequest creates a request to invoke DescribeExportImageInfo API
func CreateDescribeExportImageInfoRequest() (request *DescribeExportImageInfoRequest) {
	request = &DescribeExportImageInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeExportImageInfo", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExportImageInfoResponse creates a response to parse from DescribeExportImageInfo response
func CreateDescribeExportImageInfoResponse() (response *DescribeExportImageInfoResponse) {
	response = &DescribeExportImageInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
