package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpenStoreUsage invokes the elasticsearch.GetOpenStoreUsage API synchronously
func (client *Client) GetOpenStoreUsage(request *GetOpenStoreUsageRequest) (response *GetOpenStoreUsageResponse, err error) {
	response = CreateGetOpenStoreUsageResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpenStoreUsageWithChan invokes the elasticsearch.GetOpenStoreUsage API asynchronously
func (client *Client) GetOpenStoreUsageWithChan(request *GetOpenStoreUsageRequest) (<-chan *GetOpenStoreUsageResponse, <-chan error) {
	responseChan := make(chan *GetOpenStoreUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpenStoreUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpenStoreUsageWithCallback invokes the elasticsearch.GetOpenStoreUsage API asynchronously
func (client *Client) GetOpenStoreUsageWithCallback(request *GetOpenStoreUsageRequest, callback func(response *GetOpenStoreUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpenStoreUsageResponse
		var err error
		defer close(result)
		response, err = client.GetOpenStoreUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpenStoreUsageRequest is the request struct for api GetOpenStoreUsage
type GetOpenStoreUsageRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// GetOpenStoreUsageResponse is the response struct for api GetOpenStoreUsage
type GetOpenStoreUsageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetOpenStoreUsageRequest creates a request to invoke GetOpenStoreUsage API
func CreateGetOpenStoreUsageRequest() (request *GetOpenStoreUsageRequest) {
	request = &GetOpenStoreUsageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "GetOpenStoreUsage", "/openapi/instances/[InstanceId]/openstore/usage", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetOpenStoreUsageResponse creates a response to parse from GetOpenStoreUsage response
func CreateGetOpenStoreUsageResponse() (response *GetOpenStoreUsageResponse) {
	response = &GetOpenStoreUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
