package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableKibanaPvlNetwork invokes the elasticsearch.EnableKibanaPvlNetwork API synchronously
func (client *Client) EnableKibanaPvlNetwork(request *EnableKibanaPvlNetworkRequest) (response *EnableKibanaPvlNetworkResponse, err error) {
	response = CreateEnableKibanaPvlNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// EnableKibanaPvlNetworkWithChan invokes the elasticsearch.EnableKibanaPvlNetwork API asynchronously
func (client *Client) EnableKibanaPvlNetworkWithChan(request *EnableKibanaPvlNetworkRequest) (<-chan *EnableKibanaPvlNetworkResponse, <-chan error) {
	responseChan := make(chan *EnableKibanaPvlNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableKibanaPvlNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableKibanaPvlNetworkWithCallback invokes the elasticsearch.EnableKibanaPvlNetwork API asynchronously
func (client *Client) EnableKibanaPvlNetworkWithCallback(request *EnableKibanaPvlNetworkRequest, callback func(response *EnableKibanaPvlNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableKibanaPvlNetworkResponse
		var err error
		defer close(result)
		response, err = client.EnableKibanaPvlNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableKibanaPvlNetworkRequest is the request struct for api EnableKibanaPvlNetwork
type EnableKibanaPvlNetworkRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Body       string `position:"Body" name:"body"`
}

// EnableKibanaPvlNetworkResponse is the response struct for api EnableKibanaPvlNetwork
type EnableKibanaPvlNetworkResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableKibanaPvlNetworkRequest creates a request to invoke EnableKibanaPvlNetwork API
func CreateEnableKibanaPvlNetworkRequest() (request *EnableKibanaPvlNetworkRequest) {
	request = &EnableKibanaPvlNetworkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "EnableKibanaPvlNetwork", "/openapi/instances/[InstanceId]/actions/enable-kibana-private", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableKibanaPvlNetworkResponse creates a response to parse from EnableKibanaPvlNetwork response
func CreateEnableKibanaPvlNetworkResponse() (response *EnableKibanaPvlNetworkResponse) {
	response = &EnableKibanaPvlNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
