package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteErAttachment invokes the eflo.DeleteErAttachment API synchronously
func (client *Client) DeleteErAttachment(request *DeleteErAttachmentRequest) (response *DeleteErAttachmentResponse, err error) {
	response = CreateDeleteErAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteErAttachmentWithChan invokes the eflo.DeleteErAttachment API asynchronously
func (client *Client) DeleteErAttachmentWithChan(request *DeleteErAttachmentRequest) (<-chan *DeleteErAttachmentResponse, <-chan error) {
	responseChan := make(chan *DeleteErAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteErAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteErAttachmentWithCallback invokes the eflo.DeleteErAttachment API asynchronously
func (client *Client) DeleteErAttachmentWithCallback(request *DeleteErAttachmentRequest, callback func(response *DeleteErAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteErAttachmentResponse
		var err error
		defer close(result)
		response, err = client.DeleteErAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteErAttachmentRequest is the request struct for api DeleteErAttachment
type DeleteErAttachmentRequest struct {
	*requests.RpcRequest
	ErId           string `position:"Body" name:"ErId"`
	ErAttachmentId string `position:"Body" name:"ErAttachmentId"`
}

// DeleteErAttachmentResponse is the response struct for api DeleteErAttachment
type DeleteErAttachmentResponse struct {
	*responses.BaseResponse
}

// CreateDeleteErAttachmentRequest creates a request to invoke DeleteErAttachment API
func CreateDeleteErAttachmentRequest() (request *DeleteErAttachmentRequest) {
	request = &DeleteErAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteErAttachment", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteErAttachmentResponse creates a response to parse from DeleteErAttachment response
func CreateDeleteErAttachmentResponse() (response *DeleteErAttachmentResponse) {
	response = &DeleteErAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
