package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVccRouteEntry invokes the eflo.CreateVccRouteEntry API synchronously
func (client *Client) CreateVccRouteEntry(request *CreateVccRouteEntryRequest) (response *CreateVccRouteEntryResponse, err error) {
	response = CreateCreateVccRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVccRouteEntryWithChan invokes the eflo.CreateVccRouteEntry API asynchronously
func (client *Client) CreateVccRouteEntryWithChan(request *CreateVccRouteEntryRequest) (<-chan *CreateVccRouteEntryResponse, <-chan error) {
	responseChan := make(chan *CreateVccRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVccRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVccRouteEntryWithCallback invokes the eflo.CreateVccRouteEntry API asynchronously
func (client *Client) CreateVccRouteEntryWithCallback(request *CreateVccRouteEntryRequest, callback func(response *CreateVccRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVccRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.CreateVccRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVccRouteEntryRequest is the request struct for api CreateVccRouteEntry
type CreateVccRouteEntryRequest struct {
	*requests.RpcRequest
	DestinationCidrBlock string `position:"Body" name:"DestinationCidrBlock"`
	VccId                string `position:"Body" name:"VccId"`
}

// CreateVccRouteEntryResponse is the response struct for api CreateVccRouteEntry
type CreateVccRouteEntryResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateCreateVccRouteEntryRequest creates a request to invoke CreateVccRouteEntry API
func CreateCreateVccRouteEntryRequest() (request *CreateVccRouteEntryRequest) {
	request = &CreateVccRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "CreateVccRouteEntry", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVccRouteEntryResponse creates a response to parse from CreateVccRouteEntry response
func CreateCreateVccRouteEntryResponse() (response *CreateVccRouteEntryResponse) {
	response = &CreateVccRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
