package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForTransferOutByAuthorizationCode invokes the domain.SaveSingleTaskForTransferOutByAuthorizationCode API synchronously
func (client *Client) SaveSingleTaskForTransferOutByAuthorizationCode(request *SaveSingleTaskForTransferOutByAuthorizationCodeRequest) (response *SaveSingleTaskForTransferOutByAuthorizationCodeResponse, err error) {
	response = CreateSaveSingleTaskForTransferOutByAuthorizationCodeResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForTransferOutByAuthorizationCodeWithChan invokes the domain.SaveSingleTaskForTransferOutByAuthorizationCode API asynchronously
func (client *Client) SaveSingleTaskForTransferOutByAuthorizationCodeWithChan(request *SaveSingleTaskForTransferOutByAuthorizationCodeRequest) (<-chan *SaveSingleTaskForTransferOutByAuthorizationCodeResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForTransferOutByAuthorizationCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForTransferOutByAuthorizationCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForTransferOutByAuthorizationCodeWithCallback invokes the domain.SaveSingleTaskForTransferOutByAuthorizationCode API asynchronously
func (client *Client) SaveSingleTaskForTransferOutByAuthorizationCodeWithCallback(request *SaveSingleTaskForTransferOutByAuthorizationCodeRequest, callback func(response *SaveSingleTaskForTransferOutByAuthorizationCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForTransferOutByAuthorizationCodeResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForTransferOutByAuthorizationCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForTransferOutByAuthorizationCodeRequest is the request struct for api SaveSingleTaskForTransferOutByAuthorizationCode
type SaveSingleTaskForTransferOutByAuthorizationCodeRequest struct {
	*requests.RpcRequest
	DomainName        string `position:"Query" name:"DomainName"`
	AuthorizationCode string `position:"Query" name:"AuthorizationCode"`
	UserClientIp      string `position:"Query" name:"UserClientIp"`
	Lang              string `position:"Query" name:"Lang"`
}

// SaveSingleTaskForTransferOutByAuthorizationCodeResponse is the response struct for api SaveSingleTaskForTransferOutByAuthorizationCode
type SaveSingleTaskForTransferOutByAuthorizationCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForTransferOutByAuthorizationCodeRequest creates a request to invoke SaveSingleTaskForTransferOutByAuthorizationCode API
func CreateSaveSingleTaskForTransferOutByAuthorizationCodeRequest() (request *SaveSingleTaskForTransferOutByAuthorizationCodeRequest) {
	request = &SaveSingleTaskForTransferOutByAuthorizationCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForTransferOutByAuthorizationCode", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForTransferOutByAuthorizationCodeResponse creates a response to parse from SaveSingleTaskForTransferOutByAuthorizationCode response
func CreateSaveSingleTaskForTransferOutByAuthorizationCodeResponse() (response *SaveSingleTaskForTransferOutByAuthorizationCodeResponse) {
	response = &SaveSingleTaskForTransferOutByAuthorizationCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
