package domain_intl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDomainRealNameVerificationInfo invokes the domain_intl.QueryDomainRealNameVerificationInfo API synchronously
// api document: https://help.aliyun.com/api/domain-intl/querydomainrealnameverificationinfo.html
func (client *Client) QueryDomainRealNameVerificationInfo(request *QueryDomainRealNameVerificationInfoRequest) (response *QueryDomainRealNameVerificationInfoResponse, err error) {
	response = CreateQueryDomainRealNameVerificationInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDomainRealNameVerificationInfoWithChan invokes the domain_intl.QueryDomainRealNameVerificationInfo API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/querydomainrealnameverificationinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryDomainRealNameVerificationInfoWithChan(request *QueryDomainRealNameVerificationInfoRequest) (<-chan *QueryDomainRealNameVerificationInfoResponse, <-chan error) {
	responseChan := make(chan *QueryDomainRealNameVerificationInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDomainRealNameVerificationInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDomainRealNameVerificationInfoWithCallback invokes the domain_intl.QueryDomainRealNameVerificationInfo API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/querydomainrealnameverificationinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryDomainRealNameVerificationInfoWithCallback(request *QueryDomainRealNameVerificationInfoRequest, callback func(response *QueryDomainRealNameVerificationInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDomainRealNameVerificationInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryDomainRealNameVerificationInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDomainRealNameVerificationInfoRequest is the request struct for api QueryDomainRealNameVerificationInfo
type QueryDomainRealNameVerificationInfoRequest struct {
	*requests.RpcRequest
	FetchImage   requests.Boolean `position:"Query" name:"FetchImage"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	DomainName   string           `position:"Query" name:"DomainName"`
	Lang         string           `position:"Query" name:"Lang"`
}

// QueryDomainRealNameVerificationInfoResponse is the response struct for api QueryDomainRealNameVerificationInfo
type QueryDomainRealNameVerificationInfoResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	SubmissionDate         string `json:"SubmissionDate" xml:"SubmissionDate"`
	IdentityCredential     string `json:"IdentityCredential" xml:"IdentityCredential"`
	IdentityCredentialNo   string `json:"IdentityCredentialNo" xml:"IdentityCredentialNo"`
	IdentityCredentialType string `json:"IdentityCredentialType" xml:"IdentityCredentialType"`
	DomainName             string `json:"DomainName" xml:"DomainName"`
	InstanceId             string `json:"InstanceId" xml:"InstanceId"`
	IdentityCredentialUrl  string `json:"IdentityCredentialUrl" xml:"IdentityCredentialUrl"`
}

// CreateQueryDomainRealNameVerificationInfoRequest creates a request to invoke QueryDomainRealNameVerificationInfo API
func CreateQueryDomainRealNameVerificationInfoRequest() (request *QueryDomainRealNameVerificationInfoRequest) {
	request = &QueryDomainRealNameVerificationInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain-intl", "2017-12-18", "QueryDomainRealNameVerificationInfo", "domain", "openAPI")
	return
}

// CreateQueryDomainRealNameVerificationInfoResponse creates a response to parse from QueryDomainRealNameVerificationInfo response
func CreateQueryDomainRealNameVerificationInfoResponse() (response *QueryDomainRealNameVerificationInfoResponse) {
	response = &QueryDomainRealNameVerificationInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
