package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAbacPolicy invokes the dms_enterprise.UpdateAbacPolicy API synchronously
func (client *Client) UpdateAbacPolicy(request *UpdateAbacPolicyRequest) (response *UpdateAbacPolicyResponse, err error) {
	response = CreateUpdateAbacPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAbacPolicyWithChan invokes the dms_enterprise.UpdateAbacPolicy API asynchronously
func (client *Client) UpdateAbacPolicyWithChan(request *UpdateAbacPolicyRequest) (<-chan *UpdateAbacPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateAbacPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAbacPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAbacPolicyWithCallback invokes the dms_enterprise.UpdateAbacPolicy API asynchronously
func (client *Client) UpdateAbacPolicyWithCallback(request *UpdateAbacPolicyRequest, callback func(response *UpdateAbacPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAbacPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateAbacPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAbacPolicyRequest is the request struct for api UpdateAbacPolicy
type UpdateAbacPolicyRequest struct {
	*requests.RpcRequest
	AbacPolicyContent string           `position:"Query" name:"AbacPolicyContent"`
	Tid               requests.Integer `position:"Query" name:"Tid"`
	AbacPolicyId      requests.Integer `position:"Query" name:"AbacPolicyId"`
	AbacPolicyDesc    string           `position:"Query" name:"AbacPolicyDesc"`
	AbacPolicyName    string           `position:"Query" name:"AbacPolicyName"`
}

// UpdateAbacPolicyResponse is the response struct for api UpdateAbacPolicy
type UpdateAbacPolicyResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ErrorCode          string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage       string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success            bool   `json:"Success" xml:"Success"`
	UpdatePolicyResult int64  `json:"UpdatePolicyResult" xml:"UpdatePolicyResult"`
}

// CreateUpdateAbacPolicyRequest creates a request to invoke UpdateAbacPolicy API
func CreateUpdateAbacPolicyRequest() (request *UpdateAbacPolicyRequest) {
	request = &UpdateAbacPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateAbacPolicy", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAbacPolicyResponse creates a response to parse from UpdateAbacPolicy response
func CreateUpdateAbacPolicyResponse() (response *UpdateAbacPolicyResponse) {
	response = &UpdateAbacPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
