package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefundPayAsYouGoOrder invokes the dms_enterprise.RefundPayAsYouGoOrder API synchronously
func (client *Client) RefundPayAsYouGoOrder(request *RefundPayAsYouGoOrderRequest) (response *RefundPayAsYouGoOrderResponse, err error) {
	response = CreateRefundPayAsYouGoOrderResponse()
	err = client.DoAction(request, response)
	return
}

// RefundPayAsYouGoOrderWithChan invokes the dms_enterprise.RefundPayAsYouGoOrder API asynchronously
func (client *Client) RefundPayAsYouGoOrderWithChan(request *RefundPayAsYouGoOrderRequest) (<-chan *RefundPayAsYouGoOrderResponse, <-chan error) {
	responseChan := make(chan *RefundPayAsYouGoOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefundPayAsYouGoOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefundPayAsYouGoOrderWithCallback invokes the dms_enterprise.RefundPayAsYouGoOrder API asynchronously
func (client *Client) RefundPayAsYouGoOrderWithCallback(request *RefundPayAsYouGoOrderRequest, callback func(response *RefundPayAsYouGoOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefundPayAsYouGoOrderResponse
		var err error
		defer close(result)
		response, err = client.RefundPayAsYouGoOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefundPayAsYouGoOrderRequest is the request struct for api RefundPayAsYouGoOrder
type RefundPayAsYouGoOrderRequest struct {
	*requests.RpcRequest
	Tid        requests.Integer `position:"Query" name:"Tid"`
	OrderId    string           `position:"Query" name:"OrderId"`
	InstanceId string           `position:"Query" name:"InstanceId"`
}

// RefundPayAsYouGoOrderResponse is the response struct for api RefundPayAsYouGoOrder
type RefundPayAsYouGoOrderResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateRefundPayAsYouGoOrderRequest creates a request to invoke RefundPayAsYouGoOrder API
func CreateRefundPayAsYouGoOrderRequest() (request *RefundPayAsYouGoOrderRequest) {
	request = &RefundPayAsYouGoOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "RefundPayAsYouGoOrder", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefundPayAsYouGoOrderResponse creates a response to parse from RefundPayAsYouGoOrder response
func CreateRefundPayAsYouGoOrderResponse() (response *RefundPayAsYouGoOrderResponse) {
	response = &RefundPayAsYouGoOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
