package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMetaCollectionEntity invokes the dataworks_public.AddMetaCollectionEntity API synchronously
func (client *Client) AddMetaCollectionEntity(request *AddMetaCollectionEntityRequest) (response *AddMetaCollectionEntityResponse, err error) {
	response = CreateAddMetaCollectionEntityResponse()
	err = client.DoAction(request, response)
	return
}

// AddMetaCollectionEntityWithChan invokes the dataworks_public.AddMetaCollectionEntity API asynchronously
func (client *Client) AddMetaCollectionEntityWithChan(request *AddMetaCollectionEntityRequest) (<-chan *AddMetaCollectionEntityResponse, <-chan error) {
	responseChan := make(chan *AddMetaCollectionEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMetaCollectionEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMetaCollectionEntityWithCallback invokes the dataworks_public.AddMetaCollectionEntity API asynchronously
func (client *Client) AddMetaCollectionEntityWithCallback(request *AddMetaCollectionEntityRequest, callback func(response *AddMetaCollectionEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMetaCollectionEntityResponse
		var err error
		defer close(result)
		response, err = client.AddMetaCollectionEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMetaCollectionEntityRequest is the request struct for api AddMetaCollectionEntity
type AddMetaCollectionEntityRequest struct {
	*requests.RpcRequest
	EntityQualifiedName     string `position:"Query" name:"EntityQualifiedName"`
	Remark                  string `position:"Query" name:"Remark"`
	CollectionQualifiedName string `position:"Query" name:"CollectionQualifiedName"`
}

// AddMetaCollectionEntityResponse is the response struct for api AddMetaCollectionEntity
type AddMetaCollectionEntityResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Status         bool   `json:"Status" xml:"Status"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddMetaCollectionEntityRequest creates a request to invoke AddMetaCollectionEntity API
func CreateAddMetaCollectionEntityRequest() (request *AddMetaCollectionEntityRequest) {
	request = &AddMetaCollectionEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "AddMetaCollectionEntity", "", "")
	request.Method = requests.POST
	return
}

// CreateAddMetaCollectionEntityResponse creates a response to parse from AddMetaCollectionEntity response
func CreateAddMetaCollectionEntityResponse() (response *AddMetaCollectionEntityResponse) {
	response = &AddMetaCollectionEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
