package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPfsSqlSummaries invokes the das.GetPfsSqlSummaries API synchronously
func (client *Client) GetPfsSqlSummaries(request *GetPfsSqlSummariesRequest) (response *GetPfsSqlSummariesResponse, err error) {
	response = CreateGetPfsSqlSummariesResponse()
	err = client.DoAction(request, response)
	return
}

// GetPfsSqlSummariesWithChan invokes the das.GetPfsSqlSummaries API asynchronously
func (client *Client) GetPfsSqlSummariesWithChan(request *GetPfsSqlSummariesRequest) (<-chan *GetPfsSqlSummariesResponse, <-chan error) {
	responseChan := make(chan *GetPfsSqlSummariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPfsSqlSummaries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPfsSqlSummariesWithCallback invokes the das.GetPfsSqlSummaries API asynchronously
func (client *Client) GetPfsSqlSummariesWithCallback(request *GetPfsSqlSummariesRequest, callback func(response *GetPfsSqlSummariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPfsSqlSummariesResponse
		var err error
		defer close(result)
		response, err = client.GetPfsSqlSummaries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPfsSqlSummariesRequest is the request struct for api GetPfsSqlSummaries
type GetPfsSqlSummariesRequest struct {
	*requests.RpcRequest
	ConsoleContext string           `position:"Query" name:"ConsoleContext"`
	InstanceId     string           `position:"Body" name:"InstanceId"`
	NodeId         string           `position:"Body" name:"NodeId"`
	SqlId          string           `position:"Body" name:"SqlId"`
	Keywords       string           `position:"Body" name:"Keywords"`
	StartTime      requests.Integer `position:"Body" name:"StartTime"`
	EndTime        requests.Integer `position:"Body" name:"EndTime"`
	OrderBy        string           `position:"Body" name:"OrderBy"`
	Asc            requests.Boolean `position:"Body" name:"Asc"`
	PageNo         requests.Integer `position:"Body" name:"PageNo"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
}

// GetPfsSqlSummariesResponse is the response struct for api GetPfsSqlSummaries
type GetPfsSqlSummariesResponse struct {
	*responses.BaseResponse
}

// CreateGetPfsSqlSummariesRequest creates a request to invoke GetPfsSqlSummaries API
func CreateGetPfsSqlSummariesRequest() (request *GetPfsSqlSummariesRequest) {
	request = &GetPfsSqlSummariesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetPfsSqlSummaries", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPfsSqlSummariesResponse creates a response to parse from GetPfsSqlSummaries response
func CreateGetPfsSqlSummariesResponse() (response *GetPfsSqlSummariesResponse) {
	response = &GetPfsSqlSummariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
