package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserGroupsForPrivateAccessPolicy invokes the csas.ListUserGroupsForPrivateAccessPolicy API synchronously
func (client *Client) ListUserGroupsForPrivateAccessPolicy(request *ListUserGroupsForPrivateAccessPolicyRequest) (response *ListUserGroupsForPrivateAccessPolicyResponse, err error) {
	response = CreateListUserGroupsForPrivateAccessPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserGroupsForPrivateAccessPolicyWithChan invokes the csas.ListUserGroupsForPrivateAccessPolicy API asynchronously
func (client *Client) ListUserGroupsForPrivateAccessPolicyWithChan(request *ListUserGroupsForPrivateAccessPolicyRequest) (<-chan *ListUserGroupsForPrivateAccessPolicyResponse, <-chan error) {
	responseChan := make(chan *ListUserGroupsForPrivateAccessPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserGroupsForPrivateAccessPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserGroupsForPrivateAccessPolicyWithCallback invokes the csas.ListUserGroupsForPrivateAccessPolicy API asynchronously
func (client *Client) ListUserGroupsForPrivateAccessPolicyWithCallback(request *ListUserGroupsForPrivateAccessPolicyRequest, callback func(response *ListUserGroupsForPrivateAccessPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserGroupsForPrivateAccessPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListUserGroupsForPrivateAccessPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserGroupsForPrivateAccessPolicyRequest is the request struct for api ListUserGroupsForPrivateAccessPolicy
type ListUserGroupsForPrivateAccessPolicyRequest struct {
	*requests.RpcRequest
	PolicyIds *[]string `position:"Query" name:"PolicyIds"  type:"Repeated"`
	SourceIp  string    `position:"Query" name:"SourceIp"`
}

// ListUserGroupsForPrivateAccessPolicyResponse is the response struct for api ListUserGroupsForPrivateAccessPolicy
type ListUserGroupsForPrivateAccessPolicyResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Polices   []Policy `json:"Polices" xml:"Polices"`
}

// CreateListUserGroupsForPrivateAccessPolicyRequest creates a request to invoke ListUserGroupsForPrivateAccessPolicy API
func CreateListUserGroupsForPrivateAccessPolicyRequest() (request *ListUserGroupsForPrivateAccessPolicyRequest) {
	request = &ListUserGroupsForPrivateAccessPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListUserGroupsForPrivateAccessPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateListUserGroupsForPrivateAccessPolicyResponse creates a response to parse from ListUserGroupsForPrivateAccessPolicy response
func CreateListUserGroupsForPrivateAccessPolicyResponse() (response *ListUserGroupsForPrivateAccessPolicyResponse) {
	response = &ListUserGroupsForPrivateAccessPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
