package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceRelations invokes the config.ListResourceRelations API synchronously
func (client *Client) ListResourceRelations(request *ListResourceRelationsRequest) (response *ListResourceRelationsResponse, err error) {
	response = CreateListResourceRelationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceRelationsWithChan invokes the config.ListResourceRelations API asynchronously
func (client *Client) ListResourceRelationsWithChan(request *ListResourceRelationsRequest) (<-chan *ListResourceRelationsResponse, <-chan error) {
	responseChan := make(chan *ListResourceRelationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceRelations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceRelationsWithCallback invokes the config.ListResourceRelations API asynchronously
func (client *Client) ListResourceRelationsWithCallback(request *ListResourceRelationsRequest, callback func(response *ListResourceRelationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceRelationsResponse
		var err error
		defer close(result)
		response, err = client.ListResourceRelations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceRelationsRequest is the request struct for api ListResourceRelations
type ListResourceRelationsRequest struct {
	*requests.RpcRequest
	TargetResourceType string           `position:"Query" name:"TargetResourceType"`
	ResourceId         string           `position:"Query" name:"ResourceId"`
	TargetResourceId   string           `position:"Query" name:"TargetResourceId"`
	ResourceType       string           `position:"Query" name:"ResourceType"`
	RelationType       string           `position:"Query" name:"RelationType"`
	NextToken          string           `position:"Query" name:"NextToken"`
	MaxResults         requests.Integer `position:"Query" name:"MaxResults"`
	Region             string           `position:"Query" name:"Region"`
}

// ListResourceRelationsResponse is the response struct for api ListResourceRelations
type ListResourceRelationsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ResourceRelations ResourceRelations `json:"ResourceRelations" xml:"ResourceRelations"`
}

// CreateListResourceRelationsRequest creates a request to invoke ListResourceRelations API
func CreateListResourceRelationsRequest() (request *ListResourceRelationsRequest) {
	request = &ListResourceRelationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListResourceRelations", "", "")
	request.Method = requests.POST
	return
}

// CreateListResourceRelationsResponse creates a response to parse from ListResourceRelations response
func CreateListResourceRelationsResponse() (response *ListResourceRelationsResponse) {
	response = &ListResourceRelationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
