package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CredentialVerify invokes the cloudauth.CredentialVerify API synchronously
func (client *Client) CredentialVerify(request *CredentialVerifyRequest) (response *CredentialVerifyResponse, err error) {
	response = CreateCredentialVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// CredentialVerifyWithChan invokes the cloudauth.CredentialVerify API asynchronously
func (client *Client) CredentialVerifyWithChan(request *CredentialVerifyRequest) (<-chan *CredentialVerifyResponse, <-chan error) {
	responseChan := make(chan *CredentialVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CredentialVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CredentialVerifyWithCallback invokes the cloudauth.CredentialVerify API asynchronously
func (client *Client) CredentialVerifyWithCallback(request *CredentialVerifyRequest, callback func(response *CredentialVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CredentialVerifyResponse
		var err error
		defer close(result)
		response, err = client.CredentialVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CredentialVerifyRequest is the request struct for api CredentialVerify
type CredentialVerifyRequest struct {
	*requests.RpcRequest
	ProductCode    string                            `position:"Query" name:"ProductCode"`
	IsOCR          string                            `position:"Query" name:"IsOCR"`
	IsCheck        string                            `position:"Query" name:"IsCheck"`
	ImageContext   string                            `position:"Body" name:"ImageContext"`
	CredType       string                            `position:"Query" name:"CredType"`
	PromptModel    string                            `position:"Query" name:"PromptModel"`
	IdentifyNum    string                            `position:"Query" name:"IdentifyNum"`
	CredName       string                            `position:"Query" name:"CredName"`
	MerchantId     string                            `position:"Query" name:"MerchantId"`
	MerchantDetail *[]CredentialVerifyMerchantDetail `position:"Query" name:"MerchantDetail"  type:"Json"`
	ImageUrl       string                            `position:"Query" name:"ImageUrl"`
	CertNum        string                            `position:"Query" name:"CertNum"`
	Prompt         string                            `position:"Query" name:"Prompt"`
	UserName       string                            `position:"Query" name:"UserName"`
}

// CredentialVerifyMerchantDetail is a repeated param struct in CredentialVerifyRequest
type CredentialVerifyMerchantDetail struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CredentialVerifyResponse is the response struct for api CredentialVerify
type CredentialVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateCredentialVerifyRequest creates a request to invoke CredentialVerify API
func CreateCredentialVerifyRequest() (request *CredentialVerifyRequest) {
	request = &CredentialVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "CredentialVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCredentialVerifyResponse creates a response to parse from CredentialVerify response
func CreateCredentialVerifyResponse() (response *CredentialVerifyResponse) {
	response = &CredentialVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
