package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchJobCheck invokes the cloud_siem.BatchJobCheck API synchronously
func (client *Client) BatchJobCheck(request *BatchJobCheckRequest) (response *BatchJobCheckResponse, err error) {
	response = CreateBatchJobCheckResponse()
	err = client.DoAction(request, response)
	return
}

// BatchJobCheckWithChan invokes the cloud_siem.BatchJobCheck API asynchronously
func (client *Client) BatchJobCheckWithChan(request *BatchJobCheckRequest) (<-chan *BatchJobCheckResponse, <-chan error) {
	responseChan := make(chan *BatchJobCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchJobCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchJobCheckWithCallback invokes the cloud_siem.BatchJobCheck API asynchronously
func (client *Client) BatchJobCheckWithCallback(request *BatchJobCheckRequest, callback func(response *BatchJobCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchJobCheckResponse
		var err error
		defer close(result)
		response, err = client.BatchJobCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchJobCheckRequest is the request struct for api BatchJobCheck
type BatchJobCheckRequest struct {
	*requests.RpcRequest
	SubmitId string `position:"Body" name:"SubmitId"`
}

// BatchJobCheckResponse is the response struct for api BatchJobCheck
type BatchJobCheckResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBatchJobCheckRequest creates a request to invoke BatchJobCheck API
func CreateBatchJobCheckRequest() (request *BatchJobCheckRequest) {
	request = &BatchJobCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "BatchJobCheck", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchJobCheckResponse creates a response to parse from BatchJobCheck response
func CreateBatchJobCheckResponse() (response *BatchJobCheckResponse) {
	response = &BatchJobCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
