package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitAudioTo2DAvatarVideoTask invokes the avatar.SubmitAudioTo2DAvatarVideoTask API synchronously
func (client *Client) SubmitAudioTo2DAvatarVideoTask(request *SubmitAudioTo2DAvatarVideoTaskRequest) (response *SubmitAudioTo2DAvatarVideoTaskResponse, err error) {
	response = CreateSubmitAudioTo2DAvatarVideoTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitAudioTo2DAvatarVideoTaskWithChan invokes the avatar.SubmitAudioTo2DAvatarVideoTask API asynchronously
func (client *Client) SubmitAudioTo2DAvatarVideoTaskWithChan(request *SubmitAudioTo2DAvatarVideoTaskRequest) (<-chan *SubmitAudioTo2DAvatarVideoTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitAudioTo2DAvatarVideoTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitAudioTo2DAvatarVideoTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitAudioTo2DAvatarVideoTaskWithCallback invokes the avatar.SubmitAudioTo2DAvatarVideoTask API asynchronously
func (client *Client) SubmitAudioTo2DAvatarVideoTaskWithCallback(request *SubmitAudioTo2DAvatarVideoTaskRequest, callback func(response *SubmitAudioTo2DAvatarVideoTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitAudioTo2DAvatarVideoTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitAudioTo2DAvatarVideoTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitAudioTo2DAvatarVideoTaskRequest is the request struct for api SubmitAudioTo2DAvatarVideoTask
type SubmitAudioTo2DAvatarVideoTaskRequest struct {
	*requests.RpcRequest
	App               SubmitAudioTo2DAvatarVideoTaskApp        `position:"Query" name:"App"  type:"Struct"`
	AudioInfo         SubmitAudioTo2DAvatarVideoTaskAudioInfo  `position:"Query" name:"AudioInfo"  type:"Struct"`
	AvatarInfo        SubmitAudioTo2DAvatarVideoTaskAvatarInfo `position:"Query" name:"AvatarInfo"  type:"Struct"`
	Title             string                                   `position:"Query" name:"Title"`
	ExtParams         string                                   `position:"Query" name:"ExtParams"`
	Url               string                                   `position:"Query" name:"Url"`
	VideoInfo         SubmitAudioTo2DAvatarVideoTaskVideoInfo  `position:"Query" name:"VideoInfo"  type:"Struct"`
	CallbackParams    string                                   `position:"Query" name:"CallbackParams"`
	TenantId          requests.Integer                         `position:"Query" name:"TenantId"`
	Callback          requests.Boolean                         `position:"Query" name:"Callback"`
	ExtParamsCLS      string                                   `position:"Query" name:"ExtParams_CLS"`
	CallbackParamsCLS string                                   `position:"Query" name:"CallbackParams_CLS"`
}

// SubmitAudioTo2DAvatarVideoTaskApp is a repeated param struct in SubmitAudioTo2DAvatarVideoTaskRequest
type SubmitAudioTo2DAvatarVideoTaskApp struct {
	AppId string `name:"AppId"`
}

// SubmitAudioTo2DAvatarVideoTaskAudioInfo is a repeated param struct in SubmitAudioTo2DAvatarVideoTaskRequest
type SubmitAudioTo2DAvatarVideoTaskAudioInfo struct {
	SampleRate string `name:"SampleRate"`
}

// SubmitAudioTo2DAvatarVideoTaskAvatarInfo is a repeated param struct in SubmitAudioTo2DAvatarVideoTaskRequest
type SubmitAudioTo2DAvatarVideoTaskAvatarInfo struct {
	Code   string `name:"Code"`
	X      string `name:"X"`
	Width  string `name:"Width"`
	Y      string `name:"Y"`
	Height string `name:"Height"`
}

// SubmitAudioTo2DAvatarVideoTaskVideoInfo is a repeated param struct in SubmitAudioTo2DAvatarVideoTaskRequest
type SubmitAudioTo2DAvatarVideoTaskVideoInfo struct {
	IsAlpha            string `name:"IsAlpha"`
	BackgroundImageUrl string `name:"BackgroundImageUrl"`
	Resolution         string `name:"Resolution"`
	AlphaFormat        string `name:"AlphaFormat"`
}

// SubmitAudioTo2DAvatarVideoTaskResponse is the response struct for api SubmitAudioTo2DAvatarVideoTask
type SubmitAudioTo2DAvatarVideoTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitAudioTo2DAvatarVideoTaskRequest creates a request to invoke SubmitAudioTo2DAvatarVideoTask API
func CreateSubmitAudioTo2DAvatarVideoTaskRequest() (request *SubmitAudioTo2DAvatarVideoTaskRequest) {
	request = &SubmitAudioTo2DAvatarVideoTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "SubmitAudioTo2DAvatarVideoTask", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitAudioTo2DAvatarVideoTaskResponse creates a response to parse from SubmitAudioTo2DAvatarVideoTask response
func CreateSubmitAudioTo2DAvatarVideoTaskResponse() (response *SubmitAudioTo2DAvatarVideoTaskResponse) {
	response = &SubmitAudioTo2DAvatarVideoTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
