package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssSts invokes the apds.DescribeOssSts API synchronously
func (client *Client) DescribeOssSts(request *DescribeOssStsRequest) (response *DescribeOssStsResponse, err error) {
	response = CreateDescribeOssStsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssStsWithChan invokes the apds.DescribeOssSts API asynchronously
func (client *Client) DescribeOssStsWithChan(request *DescribeOssStsRequest) (<-chan *DescribeOssStsResponse, <-chan error) {
	responseChan := make(chan *DescribeOssStsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssSts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssStsWithCallback invokes the apds.DescribeOssSts API asynchronously
func (client *Client) DescribeOssStsWithCallback(request *DescribeOssStsRequest, callback func(response *DescribeOssStsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssStsResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssSts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssStsRequest is the request struct for api DescribeOssSts
type DescribeOssStsRequest struct {
	*requests.RoaRequest
	CloudType string `position:"Query" name:"cloudType"`
	Ak        string `position:"Query" name:"ak"`
	Sk        string `position:"Query" name:"sk"`
	TenantId  string `position:"Query" name:"tenantId"`
	Region    string `position:"Query" name:"region"`
}

// DescribeOssStsResponse is the response struct for api DescribeOssSts
type DescribeOssStsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDescribeOssStsRequest creates a request to invoke DescribeOssSts API
func CreateDescribeOssStsRequest() (request *DescribeOssStsRequest) {
	request = &DescribeOssStsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DescribeOssSts", "/okss-services/file-job/sts", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeOssStsResponse creates a response to parse from DescribeOssSts response
func CreateDescribeOssStsResponse() (response *DescribeOssStsResponse) {
	response = &DescribeOssStsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
