package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFileJob invokes the apds.CreateFileJob API synchronously
func (client *Client) CreateFileJob(request *CreateFileJobRequest) (response *CreateFileJobResponse, err error) {
	response = CreateCreateFileJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFileJobWithChan invokes the apds.CreateFileJob API asynchronously
func (client *Client) CreateFileJobWithChan(request *CreateFileJobRequest) (<-chan *CreateFileJobResponse, <-chan error) {
	responseChan := make(chan *CreateFileJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFileJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFileJobWithCallback invokes the apds.CreateFileJob API asynchronously
func (client *Client) CreateFileJobWithCallback(request *CreateFileJobRequest, callback func(response *CreateFileJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFileJobResponse
		var err error
		defer close(result)
		response, err = client.CreateFileJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFileJobRequest is the request struct for api CreateFileJob
type CreateFileJobRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateFileJobResponse is the response struct for api CreateFileJob
type CreateFileJobResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateCreateFileJobRequest creates a request to invoke CreateFileJob API
func CreateCreateFileJobRequest() (request *CreateFileJobRequest) {
	request = &CreateFileJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "CreateFileJob", "/okss-services/file-job/create", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFileJobResponse creates a response to parse from CreateFileJob response
func CreateCreateFileJobResponse() (response *CreateFileJobResponse) {
	response = &CreateFileJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
