package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMeeting invokes the aliyuncvc.GetMeeting API synchronously
func (client *Client) GetMeeting(request *GetMeetingRequest) (response *GetMeetingResponse, err error) {
	response = CreateGetMeetingResponse()
	err = client.DoAction(request, response)
	return
}

// GetMeetingWithChan invokes the aliyuncvc.GetMeeting API asynchronously
func (client *Client) GetMeetingWithChan(request *GetMeetingRequest) (<-chan *GetMeetingResponse, <-chan error) {
	responseChan := make(chan *GetMeetingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMeeting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMeetingWithCallback invokes the aliyuncvc.GetMeeting API asynchronously
func (client *Client) GetMeetingWithCallback(request *GetMeetingRequest, callback func(response *GetMeetingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMeetingResponse
		var err error
		defer close(result)
		response, err = client.GetMeeting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMeetingRequest is the request struct for api GetMeeting
type GetMeetingRequest struct {
	*requests.RpcRequest
	MeetingUUID string `position:"Body" name:"MeetingUUID"`
}

// GetMeetingResponse is the response struct for api GetMeeting
type GetMeetingResponse struct {
	*responses.BaseResponse
	ErrorCode   int         `json:"ErrorCode" xml:"ErrorCode"`
	Message     string      `json:"Message" xml:"Message"`
	Success     bool        `json:"Success" xml:"Success"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	MeetingInfo MeetingInfo `json:"MeetingInfo" xml:"MeetingInfo"`
}

// CreateGetMeetingRequest creates a request to invoke GetMeeting API
func CreateGetMeetingRequest() (request *GetMeetingRequest) {
	request = &GetMeetingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "GetMeeting", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMeetingResponse creates a response to parse from GetMeeting response
func CreateGetMeetingResponse() (response *GetMeetingResponse) {
	response = &GetMeetingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
