package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPosChEcom invokes the alinlp.GetPosChEcom API synchronously
func (client *Client) GetPosChEcom(request *GetPosChEcomRequest) (response *GetPosChEcomResponse, err error) {
	response = CreateGetPosChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetPosChEcomWithChan invokes the alinlp.GetPosChEcom API asynchronously
func (client *Client) GetPosChEcomWithChan(request *GetPosChEcomRequest) (<-chan *GetPosChEcomResponse, <-chan error) {
	responseChan := make(chan *GetPosChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPosChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPosChEcomWithCallback invokes the alinlp.GetPosChEcom API asynchronously
func (client *Client) GetPosChEcomWithCallback(request *GetPosChEcomRequest, callback func(response *GetPosChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPosChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetPosChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPosChEcomRequest is the request struct for api GetPosChEcom
type GetPosChEcomRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	OutType     string `position:"Body" name:"OutType"`
}

// GetPosChEcomResponse is the response struct for api GetPosChEcom
type GetPosChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetPosChEcomRequest creates a request to invoke GetPosChEcom API
func CreateGetPosChEcomRequest() (request *GetPosChEcomRequest) {
	request = &GetPosChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetPosChEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPosChEcomResponse creates a response to parse from GetPosChEcom response
func CreateGetPosChEcomResponse() (response *GetPosChEcomResponse) {
	response = &GetPosChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
