package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSuspiciousExportInfo invokes the aegis.DescribeSuspiciousExportInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describesuspiciousexportinfo.html
func (client *Client) DescribeSuspiciousExportInfo(request *DescribeSuspiciousExportInfoRequest) (response *DescribeSuspiciousExportInfoResponse, err error) {
	response = CreateDescribeSuspiciousExportInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSuspiciousExportInfoWithChan invokes the aegis.DescribeSuspiciousExportInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspiciousexportinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspiciousExportInfoWithChan(request *DescribeSuspiciousExportInfoRequest) (<-chan *DescribeSuspiciousExportInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeSuspiciousExportInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSuspiciousExportInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSuspiciousExportInfoWithCallback invokes the aegis.DescribeSuspiciousExportInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspiciousexportinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspiciousExportInfoWithCallback(request *DescribeSuspiciousExportInfoRequest, callback func(response *DescribeSuspiciousExportInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSuspiciousExportInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeSuspiciousExportInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSuspiciousExportInfoRequest is the request struct for api DescribeSuspiciousExportInfo
type DescribeSuspiciousExportInfoRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	ExportId requests.Integer `position:"Query" name:"ExportId"`
}

// DescribeSuspiciousExportInfoResponse is the response struct for api DescribeSuspiciousExportInfo
type DescribeSuspiciousExportInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Id           int    `json:"Id" xml:"Id"`
	GmtCreate    int    `json:"GmtCreate" xml:"GmtCreate"`
	FileName     string `json:"FileName" xml:"FileName"`
	CurrentCount int    `json:"CurrentCount" xml:"CurrentCount"`
	TotalCount   int    `json:"TotalCount" xml:"TotalCount"`
	Progress     int    `json:"Progress" xml:"Progress"`
	ExportStatus string `json:"ExportStatus" xml:"ExportStatus"`
	Message      string `json:"Message" xml:"Message"`
	Link         string `json:"Link" xml:"Link"`
}

// CreateDescribeSuspiciousExportInfoRequest creates a request to invoke DescribeSuspiciousExportInfo API
func CreateDescribeSuspiciousExportInfoRequest() (request *DescribeSuspiciousExportInfoRequest) {
	request = &DescribeSuspiciousExportInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSuspiciousExportInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeSuspiciousExportInfoResponse creates a response to parse from DescribeSuspiciousExportInfo response
func CreateDescribeSuspiciousExportInfoResponse() (response *DescribeSuspiciousExportInfoResponse) {
	response = &DescribeSuspiciousExportInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
