// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListIpGroupCommon = "ListIpGroup"

// ListIpGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListIpGroupCommon operation. The "output" return
// value will be populated with the ListIpGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListIpGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListIpGroupCommon Send returns without error.
//
// See ListIpGroupCommon for more information on using the ListIpGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the ListIpGroupCommonRequest method.
//    req, resp := client.ListIpGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) ListIpGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListIpGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListIpGroupCommon API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation ListIpGroupCommon for usage and error information.
func (c *WAF) ListIpGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListIpGroupCommonRequest(input)
	return out, req.Send()
}

// ListIpGroupCommonWithContext is the same as ListIpGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListIpGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListIpGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListIpGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIpGroup = "ListIpGroup"

// ListIpGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the ListIpGroup operation. The "output" return
// value will be populated with the ListIpGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListIpGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListIpGroupCommon Send returns without error.
//
// See ListIpGroup for more information on using the ListIpGroup
// API call, and error handling.
//
//    // Example sending a request using the ListIpGroupRequest method.
//    req, resp := client.ListIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) ListIpGroupRequest(input *ListIpGroupInput) (req *request.Request, output *ListIpGroupOutput) {
	op := &request.Operation{
		Name:       opListIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIpGroupInput{}
	}

	output = &ListIpGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListIpGroup API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation ListIpGroup for usage and error information.
func (c *WAF) ListIpGroup(input *ListIpGroupInput) (*ListIpGroupOutput, error) {
	req, out := c.ListIpGroupRequest(input)
	return out, req.Send()
}

// ListIpGroupWithContext is the same as ListIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListIpGroupWithContext(ctx volcengine.Context, input *ListIpGroupInput, opts ...request.Option) (*ListIpGroupOutput, error) {
	req, out := c.ListIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListIpGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Ip *string `type:"string" json:",omitempty"`

	// IpGroupId is a required field
	IpGroupId *int32 `type:"int32" json:",omitempty" required:"true"`

	ListAll *string `type:"string" json:",omitempty"`

	// Page is a required field
	Page *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListIpGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIpGroupInput"}
	if s.IpGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpGroupId"))
	}
	if s.Page == nil {
		invalidParams.Add(request.NewErrParamRequired("Page"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *ListIpGroupInput) SetIp(v string) *ListIpGroupInput {
	s.Ip = &v
	return s
}

// SetIpGroupId sets the IpGroupId field's value.
func (s *ListIpGroupInput) SetIpGroupId(v int32) *ListIpGroupInput {
	s.IpGroupId = &v
	return s
}

// SetListAll sets the ListAll field's value.
func (s *ListIpGroupInput) SetListAll(v string) *ListIpGroupInput {
	s.ListAll = &v
	return s
}

// SetPage sets the Page field's value.
func (s *ListIpGroupInput) SetPage(v int32) *ListIpGroupInput {
	s.Page = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListIpGroupInput) SetPageSize(v int32) *ListIpGroupInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListIpGroupInput) SetProjectName(v string) *ListIpGroupInput {
	s.ProjectName = &v
	return s
}

type ListIpGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Count *int32 `type:"int32" json:",omitempty"`

	CurrentPage *int32 `type:"int32" json:",omitempty"`

	IpList []*string `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListIpGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIpGroupOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ListIpGroupOutput) SetCount(v int32) *ListIpGroupOutput {
	s.Count = &v
	return s
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *ListIpGroupOutput) SetCurrentPage(v int32) *ListIpGroupOutput {
	s.CurrentPage = &v
	return s
}

// SetIpList sets the IpList field's value.
func (s *ListIpGroupOutput) SetIpList(v []*string) *ListIpGroupOutput {
	s.IpList = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListIpGroupOutput) SetPageNumber(v int32) *ListIpGroupOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListIpGroupOutput) SetPageSize(v int32) *ListIpGroupOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListIpGroupOutput) SetTotalCount(v int32) *ListIpGroupOutput {
	s.TotalCount = &v
	return s
}
