// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeInstanceGroupsCommon = "DescribeInstanceGroups"

// DescribeInstanceGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstanceGroupsCommon operation. The "output" return
// value will be populated with the DescribeInstanceGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstanceGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstanceGroupsCommon Send returns without error.
//
// See DescribeInstanceGroupsCommon for more information on using the DescribeInstanceGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstanceGroupsCommonRequest method.
//    req, resp := client.DescribeInstanceGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribeInstanceGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeInstanceGroupsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeInstanceGroupsCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribeInstanceGroupsCommon for usage and error information.
func (c *VPC) DescribeInstanceGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeInstanceGroupsCommonRequest(input)
	return out, req.Send()
}

// DescribeInstanceGroupsCommonWithContext is the same as DescribeInstanceGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribeInstanceGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeInstanceGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceGroups = "DescribeInstanceGroups"

// DescribeInstanceGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstanceGroups operation. The "output" return
// value will be populated with the DescribeInstanceGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstanceGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstanceGroupsCommon Send returns without error.
//
// See DescribeInstanceGroups for more information on using the DescribeInstanceGroups
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstanceGroupsRequest method.
//    req, resp := client.DescribeInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribeInstanceGroupsRequest(input *DescribeInstanceGroupsInput) (req *request.Request, output *DescribeInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceGroupsInput{}
	}

	output = &DescribeInstanceGroupsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeInstanceGroups API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribeInstanceGroups for usage and error information.
func (c *VPC) DescribeInstanceGroups(input *DescribeInstanceGroupsInput) (*DescribeInstanceGroupsOutput, error) {
	req, out := c.DescribeInstanceGroupsRequest(input)
	return out, req.Send()
}

// DescribeInstanceGroupsWithContext is the same as DescribeInstanceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribeInstanceGroupsWithContext(ctx volcengine.Context, input *DescribeInstanceGroupsInput, opts ...request.Option) (*DescribeInstanceGroupsOutput, error) {
	req, out := c.DescribeInstanceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	InstanceGroupIds []*string `type:"list"`

	InstanceGroupName *string `type:"string"`

	MaxResults *int64 `type:"integer"`

	NextToken *string `type:"string"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `max:"100" type:"integer"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceGroupsInput"}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceGroupIds sets the InstanceGroupIds field's value.
func (s *DescribeInstanceGroupsInput) SetInstanceGroupIds(v []*string) *DescribeInstanceGroupsInput {
	s.InstanceGroupIds = v
	return s
}

// SetInstanceGroupName sets the InstanceGroupName field's value.
func (s *DescribeInstanceGroupsInput) SetInstanceGroupName(v string) *DescribeInstanceGroupsInput {
	s.InstanceGroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInstanceGroupsInput) SetMaxResults(v int64) *DescribeInstanceGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceGroupsInput) SetNextToken(v string) *DescribeInstanceGroupsInput {
	s.NextToken = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeInstanceGroupsInput) SetPageNumber(v int64) *DescribeInstanceGroupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeInstanceGroupsInput) SetPageSize(v int64) *DescribeInstanceGroupsInput {
	s.PageSize = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeInstanceGroupsInput) SetVpcId(v string) *DescribeInstanceGroupsInput {
	s.VpcId = &v
	return s
}

type DescribeInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	InstanceGroups []*InstanceGroupForDescribeInstanceGroupsOutput `type:"list"`

	NextToken *string `type:"string"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `type:"integer"`

	RequestId *string `type:"string"`

	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeInstanceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceGroupsOutput) GoString() string {
	return s.String()
}

// SetInstanceGroups sets the InstanceGroups field's value.
func (s *DescribeInstanceGroupsOutput) SetInstanceGroups(v []*InstanceGroupForDescribeInstanceGroupsOutput) *DescribeInstanceGroupsOutput {
	s.InstanceGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceGroupsOutput) SetNextToken(v string) *DescribeInstanceGroupsOutput {
	s.NextToken = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeInstanceGroupsOutput) SetPageNumber(v int64) *DescribeInstanceGroupsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeInstanceGroupsOutput) SetPageSize(v int64) *DescribeInstanceGroupsOutput {
	s.PageSize = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeInstanceGroupsOutput) SetRequestId(v string) *DescribeInstanceGroupsOutput {
	s.RequestId = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeInstanceGroupsOutput) SetTotalCount(v int64) *DescribeInstanceGroupsOutput {
	s.TotalCount = &v
	return s
}

type InstanceGroupForDescribeInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	AccountId *string `type:"string"`

	CreatedAt *string `type:"string"`

	Description *string `type:"string"`

	InstanceGroupId *string `type:"string"`

	Members []*MemberForDescribeInstanceGroupsOutput `type:"list"`

	Name *string `type:"string"`

	Status *string `type:"string"`

	UpdatedAt *string `type:"string"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupForDescribeInstanceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupForDescribeInstanceGroupsOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetAccountId(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.AccountId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetCreatedAt(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetDescription(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.Description = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetInstanceGroupId(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.InstanceGroupId = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetMembers(v []*MemberForDescribeInstanceGroupsOutput) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.Members = v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetName(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetStatus(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetUpdatedAt(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.UpdatedAt = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *InstanceGroupForDescribeInstanceGroupsOutput) SetVpcId(v string) *InstanceGroupForDescribeInstanceGroupsOutput {
	s.VpcId = &v
	return s
}

type MemberForDescribeInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	Enabled *bool `type:"boolean"`

	Id *string `type:"string"`

	Type *string `type:"string"`

	Weight *int64 `type:"integer"`
}

// String returns the string representation
func (s MemberForDescribeInstanceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberForDescribeInstanceGroupsOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *MemberForDescribeInstanceGroupsOutput) SetEnabled(v bool) *MemberForDescribeInstanceGroupsOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *MemberForDescribeInstanceGroupsOutput) SetId(v string) *MemberForDescribeInstanceGroupsOutput {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *MemberForDescribeInstanceGroupsOutput) SetType(v string) *MemberForDescribeInstanceGroupsOutput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *MemberForDescribeInstanceGroupsOutput) SetWeight(v int64) *MemberForDescribeInstanceGroupsOutput {
	s.Weight = &v
	return s
}
