// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateRouteTableCommon = "CreateRouteTable"

// CreateRouteTableCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRouteTableCommon operation. The "output" return
// value will be populated with the CreateRouteTableCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRouteTableCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRouteTableCommon Send returns without error.
//
// See CreateRouteTableCommon for more information on using the CreateRouteTableCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateRouteTableCommonRequest method.
//    req, resp := client.CreateRouteTableCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateRouteTableCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateRouteTableCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateRouteTableCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateRouteTableCommon for usage and error information.
func (c *VPC) CreateRouteTableCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateRouteTableCommonRequest(input)
	return out, req.Send()
}

// CreateRouteTableCommonWithContext is the same as CreateRouteTableCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRouteTableCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateRouteTableCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateRouteTableCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRouteTable = "CreateRouteTable"

// CreateRouteTableRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRouteTable operation. The "output" return
// value will be populated with the CreateRouteTableCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRouteTableCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRouteTableCommon Send returns without error.
//
// See CreateRouteTable for more information on using the CreateRouteTable
// API call, and error handling.
//
//    // Example sending a request using the CreateRouteTableRequest method.
//    req, resp := client.CreateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateRouteTableRequest(input *CreateRouteTableInput) (req *request.Request, output *CreateRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateRouteTable,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteTableInput{}
	}

	output = &CreateRouteTableOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateRouteTable API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateRouteTable for usage and error information.
func (c *VPC) CreateRouteTable(input *CreateRouteTableInput) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	return out, req.Send()
}

// CreateRouteTableWithContext is the same as CreateRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateRouteTableWithContext(ctx volcengine.Context, input *CreateRouteTableInput, opts ...request.Option) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateRouteTableInput struct {
	_ struct{} `type:"structure"`

	AssociateType *string `type:"string" enum:"AssociateTypeForCreateRouteTableInput"`

	ClientToken *string `type:"string"`

	Description *string `min:"1" max:"255" type:"string"`

	ProjectName *string `type:"string"`

	RouteTableName *string `min:"1" max:"128" type:"string"`

	Tags []*TagForCreateRouteTableInput `type:"list"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRouteTableInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteTableInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.RouteTableName != nil && len(*s.RouteTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteTableName", 1))
	}
	if s.RouteTableName != nil && len(*s.RouteTableName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("RouteTableName", 128, *s.RouteTableName))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociateType sets the AssociateType field's value.
func (s *CreateRouteTableInput) SetAssociateType(v string) *CreateRouteTableInput {
	s.AssociateType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRouteTableInput) SetClientToken(v string) *CreateRouteTableInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRouteTableInput) SetDescription(v string) *CreateRouteTableInput {
	s.Description = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateRouteTableInput) SetProjectName(v string) *CreateRouteTableInput {
	s.ProjectName = &v
	return s
}

// SetRouteTableName sets the RouteTableName field's value.
func (s *CreateRouteTableInput) SetRouteTableName(v string) *CreateRouteTableInput {
	s.RouteTableName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRouteTableInput) SetTags(v []*TagForCreateRouteTableInput) *CreateRouteTableInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateRouteTableInput) SetVpcId(v string) *CreateRouteTableInput {
	s.VpcId = &v
	return s
}

type CreateRouteTableOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`

	RouteTableId *string `type:"string"`
}

// String returns the string representation
func (s CreateRouteTableOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteTableOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateRouteTableOutput) SetRequestId(v string) *CreateRouteTableOutput {
	s.RequestId = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *CreateRouteTableOutput) SetRouteTableId(v string) *CreateRouteTableOutput {
	s.RouteTableId = &v
	return s
}

type TagForCreateRouteTableInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateRouteTableInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateRouteTableInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateRouteTableInput) SetKey(v string) *TagForCreateRouteTableInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateRouteTableInput) SetValue(v string) *TagForCreateRouteTableInput {
	s.Value = &v
	return s
}

const (
	// AssociateTypeForCreateRouteTableInputSubnet is a AssociateTypeForCreateRouteTableInput enum value
	AssociateTypeForCreateRouteTableInputSubnet = "Subnet"

	// AssociateTypeForCreateRouteTableInputGateway is a AssociateTypeForCreateRouteTableInput enum value
	AssociateTypeForCreateRouteTableInputGateway = "Gateway"
)
