// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAssociateRouteTableCommon = "AssociateRouteTable"

// AssociateRouteTableCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AssociateRouteTableCommon operation. The "output" return
// value will be populated with the AssociateRouteTableCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AssociateRouteTableCommon Request to send the API call to the service.
// the "output" return value is not valid until after AssociateRouteTableCommon Send returns without error.
//
// See AssociateRouteTableCommon for more information on using the AssociateRouteTableCommon
// API call, and error handling.
//
//    // Example sending a request using the AssociateRouteTableCommonRequest method.
//    req, resp := client.AssociateRouteTableCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) AssociateRouteTableCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAssociateRouteTableCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// AssociateRouteTableCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation AssociateRouteTableCommon for usage and error information.
func (c *VPC) AssociateRouteTableCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AssociateRouteTableCommonRequest(input)
	return out, req.Send()
}

// AssociateRouteTableCommonWithContext is the same as AssociateRouteTableCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRouteTableCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) AssociateRouteTableCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AssociateRouteTableCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateRouteTable = "AssociateRouteTable"

// AssociateRouteTableRequest generates a "volcengine/request.Request" representing the
// client's request for the AssociateRouteTable operation. The "output" return
// value will be populated with the AssociateRouteTableCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AssociateRouteTableCommon Request to send the API call to the service.
// the "output" return value is not valid until after AssociateRouteTableCommon Send returns without error.
//
// See AssociateRouteTable for more information on using the AssociateRouteTable
// API call, and error handling.
//
//    // Example sending a request using the AssociateRouteTableRequest method.
//    req, resp := client.AssociateRouteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) AssociateRouteTableRequest(input *AssociateRouteTableInput) (req *request.Request, output *AssociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateRouteTable,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateRouteTableInput{}
	}

	output = &AssociateRouteTableOutput{}
	req = c.newRequest(op, input, output)

	return
}

// AssociateRouteTable API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation AssociateRouteTable for usage and error information.
func (c *VPC) AssociateRouteTable(input *AssociateRouteTableInput) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	return out, req.Send()
}

// AssociateRouteTableWithContext is the same as AssociateRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) AssociateRouteTableWithContext(ctx volcengine.Context, input *AssociateRouteTableInput, opts ...request.Option) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateRouteTableInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	GatewayId *string `type:"string"`

	GatewayType *string `type:"string" enum:"GatewayTypeForAssociateRouteTableInput"`

	// RouteTableId is a required field
	RouteTableId *string `type:"string" required:"true"`

	SubnetId *string `type:"string"`
}

// String returns the string representation
func (s AssociateRouteTableInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRouteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRouteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRouteTableInput"}
	if s.RouteTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateRouteTableInput) SetClientToken(v string) *AssociateRouteTableInput {
	s.ClientToken = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *AssociateRouteTableInput) SetGatewayId(v string) *AssociateRouteTableInput {
	s.GatewayId = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *AssociateRouteTableInput) SetGatewayType(v string) *AssociateRouteTableInput {
	s.GatewayType = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *AssociateRouteTableInput) SetRouteTableId(v string) *AssociateRouteTableInput {
	s.RouteTableId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AssociateRouteTableInput) SetSubnetId(v string) *AssociateRouteTableInput {
	s.SubnetId = &v
	return s
}

type AssociateRouteTableOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s AssociateRouteTableOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRouteTableOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *AssociateRouteTableOutput) SetRequestId(v string) *AssociateRouteTableOutput {
	s.RequestId = &v
	return s
}

const (
	// GatewayTypeForAssociateRouteTableInputIpv4gateway is a GatewayTypeForAssociateRouteTableInput enum value
	GatewayTypeForAssociateRouteTableInputIpv4gateway = "Ipv4Gateway"

	// GatewayTypeForAssociateRouteTableInputIpv6gateway is a GatewayTypeForAssociateRouteTableInput enum value
	GatewayTypeForAssociateRouteTableInputIpv6gateway = "Ipv6Gateway"
)
