// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateRuleCommon = "UpdateRule"

// UpdateRuleCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateRuleCommon operation. The "output" return
// value will be populated with the UpdateRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateRuleCommon Send returns without error.
//
// See UpdateRuleCommon for more information on using the UpdateRuleCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateRuleCommonRequest method.
//    req, resp := client.UpdateRuleCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) UpdateRuleCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateRuleCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateRuleCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation UpdateRuleCommon for usage and error information.
func (c *VOLCOBSERVE) UpdateRuleCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateRuleCommonRequest(input)
	return out, req.Send()
}

// UpdateRuleCommonWithContext is the same as UpdateRuleCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) UpdateRuleCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateRuleCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value will be populated with the UpdateRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateRuleCommon Send returns without error.
//
// See UpdateRule for more information on using the UpdateRule
// API call, and error handling.
//
//    // Example sending a request using the UpdateRuleRequest method.
//    req, resp := client.UpdateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) UpdateRuleRequest(input *UpdateRuleInput) (req *request.Request, output *UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleInput{}
	}

	output = &UpdateRuleOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateRule API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation UpdateRule for usage and error information.
func (c *VOLCOBSERVE) UpdateRule(input *UpdateRuleInput) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) UpdateRuleWithContext(ctx volcengine.Context, input *UpdateRuleInput, opts ...request.Option) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConditionForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComparisonOperator *string `type:"string" json:",omitempty"`

	MetricName *string `type:"string" json:",omitempty"`

	MetricUnit *string `type:"string" json:",omitempty"`

	Period *string `type:"string" json:",omitempty"`

	Statistics *string `type:"string" json:",omitempty"`

	Threshold *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConditionForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ConditionForUpdateRuleInput) SetComparisonOperator(v string) *ConditionForUpdateRuleInput {
	s.ComparisonOperator = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ConditionForUpdateRuleInput) SetMetricName(v string) *ConditionForUpdateRuleInput {
	s.MetricName = &v
	return s
}

// SetMetricUnit sets the MetricUnit field's value.
func (s *ConditionForUpdateRuleInput) SetMetricUnit(v string) *ConditionForUpdateRuleInput {
	s.MetricUnit = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ConditionForUpdateRuleInput) SetPeriod(v string) *ConditionForUpdateRuleInput {
	s.Period = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *ConditionForUpdateRuleInput) SetStatistics(v string) *ConditionForUpdateRuleInput {
	s.Statistics = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *ConditionForUpdateRuleInput) SetThreshold(v string) *ConditionForUpdateRuleInput {
	s.Threshold = &v
	return s
}

type ConvertTagForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertTagForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTagForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ConvertTagForUpdateRuleInput) SetKey(v string) *ConvertTagForUpdateRuleInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertTagForUpdateRuleInput) SetValue(v string) *ConvertTagForUpdateRuleInput {
	s.Value = &v
	return s
}

type DimensionConditionsForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MetaCondition *MetaConditionForUpdateRuleInput `type:"structure" json:",omitempty"`

	ProjectCondition *ProjectConditionForUpdateRuleInput `type:"structure" json:",omitempty"`

	TagCondition *TagConditionForUpdateRuleInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DimensionConditionsForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionConditionsForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetMetaCondition sets the MetaCondition field's value.
func (s *DimensionConditionsForUpdateRuleInput) SetMetaCondition(v *MetaConditionForUpdateRuleInput) *DimensionConditionsForUpdateRuleInput {
	s.MetaCondition = v
	return s
}

// SetProjectCondition sets the ProjectCondition field's value.
func (s *DimensionConditionsForUpdateRuleInput) SetProjectCondition(v *ProjectConditionForUpdateRuleInput) *DimensionConditionsForUpdateRuleInput {
	s.ProjectCondition = v
	return s
}

// SetTagCondition sets the TagCondition field's value.
func (s *DimensionConditionsForUpdateRuleInput) SetTagCondition(v *TagConditionForUpdateRuleInput) *DimensionConditionsForUpdateRuleInput {
	s.TagCondition = v
	return s
}

// SetType sets the Type field's value.
func (s *DimensionConditionsForUpdateRuleInput) SetType(v string) *DimensionConditionsForUpdateRuleInput {
	s.Type = &v
	return s
}

type LevelConditionForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Conditions []*ConditionForUpdateRuleInput `type:"list" json:",omitempty"`

	Level *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LevelConditionForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LevelConditionForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetConditions sets the Conditions field's value.
func (s *LevelConditionForUpdateRuleInput) SetConditions(v []*ConditionForUpdateRuleInput) *LevelConditionForUpdateRuleInput {
	s.Conditions = v
	return s
}

// SetLevel sets the Level field's value.
func (s *LevelConditionForUpdateRuleInput) SetLevel(v string) *LevelConditionForUpdateRuleInput {
	s.Level = &v
	return s
}

type MetaConditionForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllDimensions *bool `type:"boolean" json:",omitempty"`

	Condition *string `type:"string" json:",omitempty"`

	Metas []*MetaForUpdateRuleInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MetaConditionForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetaConditionForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetAllDimensions sets the AllDimensions field's value.
func (s *MetaConditionForUpdateRuleInput) SetAllDimensions(v bool) *MetaConditionForUpdateRuleInput {
	s.AllDimensions = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *MetaConditionForUpdateRuleInput) SetCondition(v string) *MetaConditionForUpdateRuleInput {
	s.Condition = &v
	return s
}

// SetMetas sets the Metas field's value.
func (s *MetaConditionForUpdateRuleInput) SetMetas(v []*MetaForUpdateRuleInput) *MetaConditionForUpdateRuleInput {
	s.Metas = v
	return s
}

type MetaForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Comparator *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MetaForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetaForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *MetaForUpdateRuleInput) SetComparator(v string) *MetaForUpdateRuleInput {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MetaForUpdateRuleInput) SetKey(v string) *MetaForUpdateRuleInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MetaForUpdateRuleInput) SetValues(v []*string) *MetaForUpdateRuleInput {
	s.Values = v
	return s
}

type NoDataForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	EvaluationCount *int64 `type:"integer" json:",omitempty"`
}

// String returns the string representation
func (s NoDataForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NoDataForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *NoDataForUpdateRuleInput) SetEnable(v bool) *NoDataForUpdateRuleInput {
	s.Enable = &v
	return s
}

// SetEvaluationCount sets the EvaluationCount field's value.
func (s *NoDataForUpdateRuleInput) SetEvaluationCount(v int64) *NoDataForUpdateRuleInput {
	s.EvaluationCount = &v
	return s
}

type NotifyTemplateForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Channel *string `type:"string" json:",omitempty" enum:"EnumOfChannelForUpdateRuleInput"`

	NotifyTemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NotifyTemplateForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyTemplateForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *NotifyTemplateForUpdateRuleInput) SetChannel(v string) *NotifyTemplateForUpdateRuleInput {
	s.Channel = &v
	return s
}

// SetNotifyTemplateId sets the NotifyTemplateId field's value.
func (s *NotifyTemplateForUpdateRuleInput) SetNotifyTemplateId(v string) *NotifyTemplateForUpdateRuleInput {
	s.NotifyTemplateId = &v
	return s
}

type ProjectConditionForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Projects []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ProjectConditionForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectConditionForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetProjects sets the Projects field's value.
func (s *ProjectConditionForUpdateRuleInput) SetProjects(v []*string) *ProjectConditionForUpdateRuleInput {
	s.Projects = v
	return s
}

type RecoveryNotifyForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RecoveryNotifyForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecoveryNotifyForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RecoveryNotifyForUpdateRuleInput) SetEnable(v bool) *RecoveryNotifyForUpdateRuleInput {
	s.Enable = &v
	return s
}

type TagConditionForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *string `type:"string" json:",omitempty"`

	Tags []*TagForUpdateRuleInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagConditionForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagConditionForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TagConditionForUpdateRuleInput) SetCondition(v string) *TagConditionForUpdateRuleInput {
	s.Condition = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagConditionForUpdateRuleInput) SetTags(v []*TagForUpdateRuleInput) *TagConditionForUpdateRuleInput {
	s.Tags = v
	return s
}

type TagForUpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Comparator *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagForUpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForUpdateRuleInput) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *TagForUpdateRuleInput) SetComparator(v string) *TagForUpdateRuleInput {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TagForUpdateRuleInput) SetKey(v string) *TagForUpdateRuleInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagForUpdateRuleInput) SetValues(v []*string) *TagForUpdateRuleInput {
	s.Values = v
	return s
}

type UpdateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AlertMethods []*string `type:"list" json:",omitempty"`

	ConditionOperator *string `type:"string" json:",omitempty"`

	Conditions []*ConditionForUpdateRuleInput `type:"list" json:",omitempty"`

	ContactGroupIds []*string `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DimensionConditions *DimensionConditionsForUpdateRuleInput `type:"structure" json:",omitempty"`

	// EffectEndAt is a required field
	EffectEndAt *string `type:"string" json:",omitempty" required:"true"`

	// EffectStartAt is a required field
	EffectStartAt *string `type:"string" json:",omitempty" required:"true"`

	// EnableState is a required field
	EnableState *string `type:"string" json:",omitempty" required:"true"`

	// EvaluationCount is a required field
	EvaluationCount *int64 `type:"integer" json:",omitempty" required:"true"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	// Level is a required field
	Level *string `type:"string" json:",omitempty" required:"true"`

	LevelConditions []*LevelConditionForUpdateRuleInput `type:"list" json:",omitempty"`

	MultipleConditions *bool `type:"boolean" json:",omitempty"`

	// Namespace is a required field
	Namespace *string `type:"string" json:",omitempty" required:"true"`

	NoData *NoDataForUpdateRuleInput `type:"structure" json:",omitempty"`

	NotificationId *string `type:"string" json:",omitempty"`

	NotifyTemplates []*NotifyTemplateForUpdateRuleInput `type:"list" json:",omitempty"`

	OriginalDimensions map[string][]*string `type:"map" json:",omitempty"`

	RecoveryNotify *RecoveryNotifyForUpdateRuleInput `type:"structure" json:",omitempty"`

	Regions []*string `type:"list" json:",omitempty"`

	// RuleName is a required field
	RuleName *string `type:"string" json:",omitempty" required:"true"`

	// RuleType is a required field
	RuleType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfRuleTypeForUpdateRuleInput"`

	// SilenceTime is a required field
	SilenceTime *int64 `type:"integer" json:",omitempty" required:"true"`

	// SubNamespace is a required field
	SubNamespace *string `type:"string" json:",omitempty" required:"true"`

	Tags []*ConvertTagForUpdateRuleInput `type:"list" json:",omitempty"`

	Webhook *string `type:"string" json:",omitempty"`

	WebhookIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UpdateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleInput"}
	if s.EffectEndAt == nil {
		invalidParams.Add(request.NewErrParamRequired("EffectEndAt"))
	}
	if s.EffectStartAt == nil {
		invalidParams.Add(request.NewErrParamRequired("EffectStartAt"))
	}
	if s.EnableState == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableState"))
	}
	if s.EvaluationCount == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationCount"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleType"))
	}
	if s.SilenceTime == nil {
		invalidParams.Add(request.NewErrParamRequired("SilenceTime"))
	}
	if s.SubNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("SubNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertMethods sets the AlertMethods field's value.
func (s *UpdateRuleInput) SetAlertMethods(v []*string) *UpdateRuleInput {
	s.AlertMethods = v
	return s
}

// SetConditionOperator sets the ConditionOperator field's value.
func (s *UpdateRuleInput) SetConditionOperator(v string) *UpdateRuleInput {
	s.ConditionOperator = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *UpdateRuleInput) SetConditions(v []*ConditionForUpdateRuleInput) *UpdateRuleInput {
	s.Conditions = v
	return s
}

// SetContactGroupIds sets the ContactGroupIds field's value.
func (s *UpdateRuleInput) SetContactGroupIds(v []*string) *UpdateRuleInput {
	s.ContactGroupIds = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleInput) SetDescription(v string) *UpdateRuleInput {
	s.Description = &v
	return s
}

// SetDimensionConditions sets the DimensionConditions field's value.
func (s *UpdateRuleInput) SetDimensionConditions(v *DimensionConditionsForUpdateRuleInput) *UpdateRuleInput {
	s.DimensionConditions = v
	return s
}

// SetEffectEndAt sets the EffectEndAt field's value.
func (s *UpdateRuleInput) SetEffectEndAt(v string) *UpdateRuleInput {
	s.EffectEndAt = &v
	return s
}

// SetEffectStartAt sets the EffectStartAt field's value.
func (s *UpdateRuleInput) SetEffectStartAt(v string) *UpdateRuleInput {
	s.EffectStartAt = &v
	return s
}

// SetEnableState sets the EnableState field's value.
func (s *UpdateRuleInput) SetEnableState(v string) *UpdateRuleInput {
	s.EnableState = &v
	return s
}

// SetEvaluationCount sets the EvaluationCount field's value.
func (s *UpdateRuleInput) SetEvaluationCount(v int64) *UpdateRuleInput {
	s.EvaluationCount = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRuleInput) SetId(v string) *UpdateRuleInput {
	s.Id = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *UpdateRuleInput) SetLevel(v string) *UpdateRuleInput {
	s.Level = &v
	return s
}

// SetLevelConditions sets the LevelConditions field's value.
func (s *UpdateRuleInput) SetLevelConditions(v []*LevelConditionForUpdateRuleInput) *UpdateRuleInput {
	s.LevelConditions = v
	return s
}

// SetMultipleConditions sets the MultipleConditions field's value.
func (s *UpdateRuleInput) SetMultipleConditions(v bool) *UpdateRuleInput {
	s.MultipleConditions = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateRuleInput) SetNamespace(v string) *UpdateRuleInput {
	s.Namespace = &v
	return s
}

// SetNoData sets the NoData field's value.
func (s *UpdateRuleInput) SetNoData(v *NoDataForUpdateRuleInput) *UpdateRuleInput {
	s.NoData = v
	return s
}

// SetNotificationId sets the NotificationId field's value.
func (s *UpdateRuleInput) SetNotificationId(v string) *UpdateRuleInput {
	s.NotificationId = &v
	return s
}

// SetNotifyTemplates sets the NotifyTemplates field's value.
func (s *UpdateRuleInput) SetNotifyTemplates(v []*NotifyTemplateForUpdateRuleInput) *UpdateRuleInput {
	s.NotifyTemplates = v
	return s
}

// SetOriginalDimensions sets the OriginalDimensions field's value.
func (s *UpdateRuleInput) SetOriginalDimensions(v map[string][]*string) *UpdateRuleInput {
	s.OriginalDimensions = v
	return s
}

// SetRecoveryNotify sets the RecoveryNotify field's value.
func (s *UpdateRuleInput) SetRecoveryNotify(v *RecoveryNotifyForUpdateRuleInput) *UpdateRuleInput {
	s.RecoveryNotify = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *UpdateRuleInput) SetRegions(v []*string) *UpdateRuleInput {
	s.Regions = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *UpdateRuleInput) SetRuleName(v string) *UpdateRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *UpdateRuleInput) SetRuleType(v string) *UpdateRuleInput {
	s.RuleType = &v
	return s
}

// SetSilenceTime sets the SilenceTime field's value.
func (s *UpdateRuleInput) SetSilenceTime(v int64) *UpdateRuleInput {
	s.SilenceTime = &v
	return s
}

// SetSubNamespace sets the SubNamespace field's value.
func (s *UpdateRuleInput) SetSubNamespace(v string) *UpdateRuleInput {
	s.SubNamespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRuleInput) SetTags(v []*ConvertTagForUpdateRuleInput) *UpdateRuleInput {
	s.Tags = v
	return s
}

// SetWebhook sets the Webhook field's value.
func (s *UpdateRuleInput) SetWebhook(v string) *UpdateRuleInput {
	s.Webhook = &v
	return s
}

// SetWebhookIds sets the WebhookIds field's value.
func (s *UpdateRuleInput) SetWebhookIds(v []*string) *UpdateRuleInput {
	s.WebhookIds = v
	return s
}

type UpdateRuleOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UpdateRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *UpdateRuleOutput) SetData(v []*string) *UpdateRuleOutput {
	s.Data = v
	return s
}

const (
	// EnumOfAlertMethodListForUpdateRuleInputEmail is a EnumOfAlertMethodListForUpdateRuleInput enum value
	EnumOfAlertMethodListForUpdateRuleInputEmail = "Email"

	// EnumOfAlertMethodListForUpdateRuleInputPhone is a EnumOfAlertMethodListForUpdateRuleInput enum value
	EnumOfAlertMethodListForUpdateRuleInputPhone = "Phone"

	// EnumOfAlertMethodListForUpdateRuleInputSms is a EnumOfAlertMethodListForUpdateRuleInput enum value
	EnumOfAlertMethodListForUpdateRuleInputSms = "SMS"

	// EnumOfAlertMethodListForUpdateRuleInputWebhook is a EnumOfAlertMethodListForUpdateRuleInput enum value
	EnumOfAlertMethodListForUpdateRuleInputWebhook = "Webhook"
)

const (
	// EnumOfChannelForUpdateRuleInputEmail is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputEmail = "email"

	// EnumOfChannelForUpdateRuleInputSms is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputSms = "sms"

	// EnumOfChannelForUpdateRuleInputPhone is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputPhone = "phone"

	// EnumOfChannelForUpdateRuleInputLark is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputLark = "lark"

	// EnumOfChannelForUpdateRuleInputDingtalk is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputDingtalk = "dingtalk"

	// EnumOfChannelForUpdateRuleInputWecom is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputWecom = "wecom"

	// EnumOfChannelForUpdateRuleInputSlack is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputSlack = "slack"

	// EnumOfChannelForUpdateRuleInputApi is a EnumOfChannelForUpdateRuleInput enum value
	EnumOfChannelForUpdateRuleInputApi = "api"
)

const (
	// EnumOfRuleTypeForUpdateRuleInputStatic is a EnumOfRuleTypeForUpdateRuleInput enum value
	EnumOfRuleTypeForUpdateRuleInputStatic = "static"

	// EnumOfRuleTypeForUpdateRuleInputDynamic is a EnumOfRuleTypeForUpdateRuleInput enum value
	EnumOfRuleTypeForUpdateRuleInputDynamic = "dynamic"
)
