// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateEventRuleCommon = "CreateEventRule"

// CreateEventRuleCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateEventRuleCommon operation. The "output" return
// value will be populated with the CreateEventRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateEventRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateEventRuleCommon Send returns without error.
//
// See CreateEventRuleCommon for more information on using the CreateEventRuleCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateEventRuleCommonRequest method.
//    req, resp := client.CreateEventRuleCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateEventRuleCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateEventRuleCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateEventRuleCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateEventRuleCommon for usage and error information.
func (c *VOLCOBSERVE) CreateEventRuleCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateEventRuleCommonRequest(input)
	return out, req.Send()
}

// CreateEventRuleCommonWithContext is the same as CreateEventRuleCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventRuleCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateEventRuleCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateEventRuleCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventRule = "CreateEventRule"

// CreateEventRuleRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateEventRule operation. The "output" return
// value will be populated with the CreateEventRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateEventRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateEventRuleCommon Send returns without error.
//
// See CreateEventRule for more information on using the CreateEventRule
// API call, and error handling.
//
//    // Example sending a request using the CreateEventRuleRequest method.
//    req, resp := client.CreateEventRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateEventRuleRequest(input *CreateEventRuleInput) (req *request.Request, output *CreateEventRuleOutput) {
	op := &request.Operation{
		Name:       opCreateEventRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventRuleInput{}
	}

	output = &CreateEventRuleOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateEventRule API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateEventRule for usage and error information.
func (c *VOLCOBSERVE) CreateEventRule(input *CreateEventRuleInput) (*CreateEventRuleOutput, error) {
	req, out := c.CreateEventRuleRequest(input)
	return out, req.Send()
}

// CreateEventRuleWithContext is the same as CreateEventRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateEventRuleWithContext(ctx volcengine.Context, input *CreateEventRuleInput, opts ...request.Option) (*CreateEventRuleOutput, error) {
	req, out := c.CreateEventRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateEventRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ContactGroupIds []*string `type:"list" json:",omitempty"`

	ContactMethods []*string `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	EffectiveTime *EffectiveTimeForCreateEventRuleInput `type:"structure" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	// EventBusName is a required field
	EventBusName *string `min:"2" max:"127" type:"string" json:",omitempty" required:"true" enum:"EnumOfEventBusNameForCreateEventRuleInput"`

	// EventSource is a required field
	EventSource *string `type:"string" json:",omitempty" required:"true"`

	EventType []*string `type:"list" json:",omitempty"`

	FilterPattern map[string]*interface{} `type:"map" json:",omitempty"`

	// Level is a required field
	Level *string `type:"string" json:",omitempty" required:"true"`

	MessageQueue []*MessageQueueForCreateEventRuleInput `type:"list" json:",omitempty"`

	NotifyTemplates []*NotifyTemplateForCreateEventRuleInput `type:"list" json:",omitempty"`

	// RuleName is a required field
	RuleName *string `min:"2" max:"127" type:"string" json:",omitempty" required:"true"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForCreateEventRuleInput"`

	TLSTarget []*TLSTargetForCreateEventRuleInput `type:"list" json:",omitempty"`

	WebhookIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateEventRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventRuleInput"}
	if s.EventBusName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBusName"))
	}
	if s.EventBusName != nil && len(*s.EventBusName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 2))
	}
	if s.EventBusName != nil && len(*s.EventBusName) > 127 {
		invalidParams.Add(request.NewErrParamMaxLen("EventBusName", 127, *s.EventBusName))
	}
	if s.EventSource == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSource"))
	}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 2))
	}
	if s.RuleName != nil && len(*s.RuleName) > 127 {
		invalidParams.Add(request.NewErrParamMaxLen("RuleName", 127, *s.RuleName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactGroupIds sets the ContactGroupIds field's value.
func (s *CreateEventRuleInput) SetContactGroupIds(v []*string) *CreateEventRuleInput {
	s.ContactGroupIds = v
	return s
}

// SetContactMethods sets the ContactMethods field's value.
func (s *CreateEventRuleInput) SetContactMethods(v []*string) *CreateEventRuleInput {
	s.ContactMethods = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEventRuleInput) SetDescription(v string) *CreateEventRuleInput {
	s.Description = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CreateEventRuleInput) SetEffectiveTime(v *EffectiveTimeForCreateEventRuleInput) *CreateEventRuleInput {
	s.EffectiveTime = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateEventRuleInput) SetEndpoint(v string) *CreateEventRuleInput {
	s.Endpoint = &v
	return s
}

// SetEventBusName sets the EventBusName field's value.
func (s *CreateEventRuleInput) SetEventBusName(v string) *CreateEventRuleInput {
	s.EventBusName = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *CreateEventRuleInput) SetEventSource(v string) *CreateEventRuleInput {
	s.EventSource = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *CreateEventRuleInput) SetEventType(v []*string) *CreateEventRuleInput {
	s.EventType = v
	return s
}

// SetFilterPattern sets the FilterPattern field's value.
func (s *CreateEventRuleInput) SetFilterPattern(v map[string]*interface{}) *CreateEventRuleInput {
	s.FilterPattern = v
	return s
}

// SetLevel sets the Level field's value.
func (s *CreateEventRuleInput) SetLevel(v string) *CreateEventRuleInput {
	s.Level = &v
	return s
}

// SetMessageQueue sets the MessageQueue field's value.
func (s *CreateEventRuleInput) SetMessageQueue(v []*MessageQueueForCreateEventRuleInput) *CreateEventRuleInput {
	s.MessageQueue = v
	return s
}

// SetNotifyTemplates sets the NotifyTemplates field's value.
func (s *CreateEventRuleInput) SetNotifyTemplates(v []*NotifyTemplateForCreateEventRuleInput) *CreateEventRuleInput {
	s.NotifyTemplates = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *CreateEventRuleInput) SetRuleName(v string) *CreateEventRuleInput {
	s.RuleName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateEventRuleInput) SetStatus(v string) *CreateEventRuleInput {
	s.Status = &v
	return s
}

// SetTLSTarget sets the TLSTarget field's value.
func (s *CreateEventRuleInput) SetTLSTarget(v []*TLSTargetForCreateEventRuleInput) *CreateEventRuleInput {
	s.TLSTarget = v
	return s
}

// SetWebhookIds sets the WebhookIds field's value.
func (s *CreateEventRuleInput) SetWebhookIds(v []*string) *CreateEventRuleInput {
	s.WebhookIds = v
	return s
}

type CreateEventRuleOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data *DataForCreateEventRuleOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateEventRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventRuleOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *CreateEventRuleOutput) SetData(v *DataForCreateEventRuleOutput) *CreateEventRuleOutput {
	s.Data = v
	return s
}

type DataForCreateEventRuleOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RuleId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DataForCreateEventRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForCreateEventRuleOutput) GoString() string {
	return s.String()
}

// SetRuleId sets the RuleId field's value.
func (s *DataForCreateEventRuleOutput) SetRuleId(v string) *DataForCreateEventRuleOutput {
	s.RuleId = &v
	return s
}

type EffectiveTimeForCreateEventRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndTime *string `type:"string" json:",omitempty"`

	StartTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EffectiveTimeForCreateEventRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectiveTimeForCreateEventRuleInput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *EffectiveTimeForCreateEventRuleInput) SetEndTime(v string) *EffectiveTimeForCreateEventRuleInput {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *EffectiveTimeForCreateEventRuleInput) SetStartTime(v string) *EffectiveTimeForCreateEventRuleInput {
	s.StartTime = &v
	return s
}

type MessageQueueForCreateEventRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AuthEncrypt []*int64 `type:"list" json:",omitempty"`

	Endpoints *string `type:"string" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	Password *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Topic *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Username *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MessageQueueForCreateEventRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageQueueForCreateEventRuleInput) GoString() string {
	return s.String()
}

// SetAuthEncrypt sets the AuthEncrypt field's value.
func (s *MessageQueueForCreateEventRuleInput) SetAuthEncrypt(v []*int64) *MessageQueueForCreateEventRuleInput {
	s.AuthEncrypt = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *MessageQueueForCreateEventRuleInput) SetEndpoints(v string) *MessageQueueForCreateEventRuleInput {
	s.Endpoints = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *MessageQueueForCreateEventRuleInput) SetInstanceId(v string) *MessageQueueForCreateEventRuleInput {
	s.InstanceId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *MessageQueueForCreateEventRuleInput) SetPassword(v string) *MessageQueueForCreateEventRuleInput {
	s.Password = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *MessageQueueForCreateEventRuleInput) SetRegion(v string) *MessageQueueForCreateEventRuleInput {
	s.Region = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *MessageQueueForCreateEventRuleInput) SetTopic(v string) *MessageQueueForCreateEventRuleInput {
	s.Topic = &v
	return s
}

// SetType sets the Type field's value.
func (s *MessageQueueForCreateEventRuleInput) SetType(v string) *MessageQueueForCreateEventRuleInput {
	s.Type = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *MessageQueueForCreateEventRuleInput) SetUsername(v string) *MessageQueueForCreateEventRuleInput {
	s.Username = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *MessageQueueForCreateEventRuleInput) SetVpcId(v string) *MessageQueueForCreateEventRuleInput {
	s.VpcId = &v
	return s
}

type NotifyTemplateForCreateEventRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Channel *string `type:"string" json:",omitempty" enum:"EnumOfChannelForCreateEventRuleInput"`

	NotifyTemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NotifyTemplateForCreateEventRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyTemplateForCreateEventRuleInput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *NotifyTemplateForCreateEventRuleInput) SetChannel(v string) *NotifyTemplateForCreateEventRuleInput {
	s.Channel = &v
	return s
}

// SetNotifyTemplateId sets the NotifyTemplateId field's value.
func (s *NotifyTemplateForCreateEventRuleInput) SetNotifyTemplateId(v string) *NotifyTemplateForCreateEventRuleInput {
	s.NotifyTemplateId = &v
	return s
}

type TLSTargetForCreateEventRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionNameCN *string `type:"string" json:",omitempty"`

	RegionNameEN *string `type:"string" json:",omitempty"`

	TopicId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TLSTargetForCreateEventRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TLSTargetForCreateEventRuleInput) GoString() string {
	return s.String()
}

// SetProjectId sets the ProjectId field's value.
func (s *TLSTargetForCreateEventRuleInput) SetProjectId(v string) *TLSTargetForCreateEventRuleInput {
	s.ProjectId = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *TLSTargetForCreateEventRuleInput) SetProjectName(v string) *TLSTargetForCreateEventRuleInput {
	s.ProjectName = &v
	return s
}

// SetRegionNameCN sets the RegionNameCN field's value.
func (s *TLSTargetForCreateEventRuleInput) SetRegionNameCN(v string) *TLSTargetForCreateEventRuleInput {
	s.RegionNameCN = &v
	return s
}

// SetRegionNameEN sets the RegionNameEN field's value.
func (s *TLSTargetForCreateEventRuleInput) SetRegionNameEN(v string) *TLSTargetForCreateEventRuleInput {
	s.RegionNameEN = &v
	return s
}

// SetTopicId sets the TopicId field's value.
func (s *TLSTargetForCreateEventRuleInput) SetTopicId(v string) *TLSTargetForCreateEventRuleInput {
	s.TopicId = &v
	return s
}

const (
	// EnumOfChannelForCreateEventRuleInputEmail is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputEmail = "email"

	// EnumOfChannelForCreateEventRuleInputSms is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputSms = "sms"

	// EnumOfChannelForCreateEventRuleInputPhone is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputPhone = "phone"

	// EnumOfChannelForCreateEventRuleInputLark is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputLark = "lark"

	// EnumOfChannelForCreateEventRuleInputDingtalk is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputDingtalk = "dingtalk"

	// EnumOfChannelForCreateEventRuleInputWecom is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputWecom = "wecom"

	// EnumOfChannelForCreateEventRuleInputSlack is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputSlack = "slack"

	// EnumOfChannelForCreateEventRuleInputApi is a EnumOfChannelForCreateEventRuleInput enum value
	EnumOfChannelForCreateEventRuleInputApi = "api"
)

const (
	// EnumOfEventBusNameForCreateEventRuleInputDefault is a EnumOfEventBusNameForCreateEventRuleInput enum value
	EnumOfEventBusNameForCreateEventRuleInputDefault = "default"
)

const (
	// EnumOfStatusForCreateEventRuleInputEnable is a EnumOfStatusForCreateEventRuleInput enum value
	EnumOfStatusForCreateEventRuleInputEnable = "enable"

	// EnumOfStatusForCreateEventRuleInputDisable is a EnumOfStatusForCreateEventRuleInput enum value
	EnumOfStatusForCreateEventRuleInputDisable = "disable"
)
