// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vod20250101

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetAITranslationProjectCommon = "GetAITranslationProject"

// GetAITranslationProjectCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetAITranslationProjectCommon operation. The "output" return
// value will be populated with the GetAITranslationProjectCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetAITranslationProjectCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetAITranslationProjectCommon Send returns without error.
//
// See GetAITranslationProjectCommon for more information on using the GetAITranslationProjectCommon
// API call, and error handling.
//
//    // Example sending a request using the GetAITranslationProjectCommonRequest method.
//    req, resp := client.GetAITranslationProjectCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOD20250101) GetAITranslationProjectCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetAITranslationProjectCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetAITranslationProjectCommon API operation for VOD20250101.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOD20250101's
// API operation GetAITranslationProjectCommon for usage and error information.
func (c *VOD20250101) GetAITranslationProjectCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetAITranslationProjectCommonRequest(input)
	return out, req.Send()
}

// GetAITranslationProjectCommonWithContext is the same as GetAITranslationProjectCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetAITranslationProjectCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOD20250101) GetAITranslationProjectCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetAITranslationProjectCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAITranslationProject = "GetAITranslationProject"

// GetAITranslationProjectRequest generates a "volcengine/request.Request" representing the
// client's request for the GetAITranslationProject operation. The "output" return
// value will be populated with the GetAITranslationProjectCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetAITranslationProjectCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetAITranslationProjectCommon Send returns without error.
//
// See GetAITranslationProject for more information on using the GetAITranslationProject
// API call, and error handling.
//
//    // Example sending a request using the GetAITranslationProjectRequest method.
//    req, resp := client.GetAITranslationProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOD20250101) GetAITranslationProjectRequest(input *GetAITranslationProjectInput) (req *request.Request, output *GetAITranslationProjectOutput) {
	op := &request.Operation{
		Name:       opGetAITranslationProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAITranslationProjectInput{}
	}

	output = &GetAITranslationProjectOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetAITranslationProject API operation for VOD20250101.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOD20250101's
// API operation GetAITranslationProject for usage and error information.
func (c *VOD20250101) GetAITranslationProject(input *GetAITranslationProjectInput) (*GetAITranslationProjectOutput, error) {
	req, out := c.GetAITranslationProjectRequest(input)
	return out, req.Send()
}

// GetAITranslationProjectWithContext is the same as GetAITranslationProject with the addition of
// the ability to pass a context and additional request options.
//
// See GetAITranslationProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOD20250101) GetAITranslationProjectWithContext(ctx volcengine.Context, input *GetAITranslationProjectInput, opts ...request.Option) (*GetAITranslationProjectOutput, error) {
	req, out := c.GetAITranslationProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackgroundAudioForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BackgroundAudioForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackgroundAudioForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *BackgroundAudioForGetAITranslationProjectOutput) SetDurationSecond(v float64) *BackgroundAudioForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *BackgroundAudioForGetAITranslationProjectOutput) SetIsAudio(v bool) *BackgroundAudioForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *BackgroundAudioForGetAITranslationProjectOutput) SetUri(v string) *BackgroundAudioForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *BackgroundAudioForGetAITranslationProjectOutput) SetUrl(v string) *BackgroundAudioForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *BackgroundAudioForGetAITranslationProjectOutput) SetVid(v string) *BackgroundAudioForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type BackgroundClipForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Language *string `type:"string" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BackgroundClipForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackgroundClipForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *BackgroundClipForGetAITranslationProjectOutput) SetId(v string) *BackgroundClipForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *BackgroundClipForGetAITranslationProjectOutput) SetLanguage(v string) *BackgroundClipForGetAITranslationProjectOutput {
	s.Language = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *BackgroundClipForGetAITranslationProjectOutput) SetProjectId(v string) *BackgroundClipForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *BackgroundClipForGetAITranslationProjectOutput) SetTranslationType(v string) *BackgroundClipForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type ErasedSubtitleVideoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ErasedSubtitleVideoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErasedSubtitleVideoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *ErasedSubtitleVideoForGetAITranslationProjectOutput) SetDurationSecond(v float64) *ErasedSubtitleVideoForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *ErasedSubtitleVideoForGetAITranslationProjectOutput) SetIsAudio(v bool) *ErasedSubtitleVideoForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ErasedSubtitleVideoForGetAITranslationProjectOutput) SetUri(v string) *ErasedSubtitleVideoForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ErasedSubtitleVideoForGetAITranslationProjectOutput) SetUrl(v string) *ErasedSubtitleVideoForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *ErasedSubtitleVideoForGetAITranslationProjectOutput) SetVid(v string) *ErasedSubtitleVideoForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type FacialTranslationVideoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FacialTranslationVideoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FacialTranslationVideoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *FacialTranslationVideoForGetAITranslationProjectOutput) SetDurationSecond(v float64) *FacialTranslationVideoForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *FacialTranslationVideoForGetAITranslationProjectOutput) SetIsAudio(v bool) *FacialTranslationVideoForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *FacialTranslationVideoForGetAITranslationProjectOutput) SetUri(v string) *FacialTranslationVideoForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *FacialTranslationVideoForGetAITranslationProjectOutput) SetUrl(v string) *FacialTranslationVideoForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *FacialTranslationVideoForGetAITranslationProjectOutput) SetVid(v string) *FacialTranslationVideoForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type ForegroundAudioForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ForegroundAudioForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForegroundAudioForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *ForegroundAudioForGetAITranslationProjectOutput) SetDurationSecond(v float64) *ForegroundAudioForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *ForegroundAudioForGetAITranslationProjectOutput) SetIsAudio(v bool) *ForegroundAudioForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ForegroundAudioForGetAITranslationProjectOutput) SetUri(v string) *ForegroundAudioForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ForegroundAudioForGetAITranslationProjectOutput) SetUrl(v string) *ForegroundAudioForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *ForegroundAudioForGetAITranslationProjectOutput) SetVid(v string) *ForegroundAudioForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type GetAITranslationProjectInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Additions *string `type:"string" json:",omitempty"`

	// ProjectId is a required field
	ProjectId *string `type:"string" json:",omitempty" required:"true"`

	// SpaceName is a required field
	SpaceName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetAITranslationProjectInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAITranslationProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAITranslationProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAITranslationProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.SpaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SpaceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditions sets the Additions field's value.
func (s *GetAITranslationProjectInput) SetAdditions(v string) *GetAITranslationProjectInput {
	s.Additions = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *GetAITranslationProjectInput) SetProjectId(v string) *GetAITranslationProjectInput {
	s.ProjectId = &v
	return s
}

// SetSpaceName sets the SpaceName field's value.
func (s *GetAITranslationProjectInput) SetSpaceName(v string) *GetAITranslationProjectInput {
	s.SpaceName = &v
	return s
}

type GetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ProjectInfo *ProjectInfoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetProjectInfo sets the ProjectInfo field's value.
func (s *GetAITranslationProjectOutput) SetProjectInfo(v *ProjectInfoForGetAITranslationProjectOutput) *GetAITranslationProjectOutput {
	s.ProjectInfo = v
	return s
}

type InputVideoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InputVideoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InputVideoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *InputVideoForGetAITranslationProjectOutput) SetDurationSecond(v float64) *InputVideoForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *InputVideoForGetAITranslationProjectOutput) SetIsAudio(v bool) *InputVideoForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *InputVideoForGetAITranslationProjectOutput) SetUri(v string) *InputVideoForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputVideoForGetAITranslationProjectOutput) SetUrl(v string) *InputVideoForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *InputVideoForGetAITranslationProjectOutput) SetVid(v string) *InputVideoForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type OperatorConfigForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubtitleRecognitionConfig *SubtitleRecognitionConfigForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s OperatorConfigForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OperatorConfigForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetSubtitleRecognitionConfig sets the SubtitleRecognitionConfig field's value.
func (s *OperatorConfigForGetAITranslationProjectOutput) SetSubtitleRecognitionConfig(v *SubtitleRecognitionConfigForGetAITranslationProjectOutput) *OperatorConfigForGetAITranslationProjectOutput {
	s.SubtitleRecognitionConfig = v
	return s
}

type OutputVideoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OutputVideoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputVideoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *OutputVideoForGetAITranslationProjectOutput) SetDurationSecond(v float64) *OutputVideoForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *OutputVideoForGetAITranslationProjectOutput) SetIsAudio(v bool) *OutputVideoForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *OutputVideoForGetAITranslationProjectOutput) SetUri(v string) *OutputVideoForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *OutputVideoForGetAITranslationProjectOutput) SetUrl(v string) *OutputVideoForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *OutputVideoForGetAITranslationProjectOutput) SetVid(v string) *OutputVideoForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type PreviewVideoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PreviewVideoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PreviewVideoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *PreviewVideoForGetAITranslationProjectOutput) SetDurationSecond(v float64) *PreviewVideoForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *PreviewVideoForGetAITranslationProjectOutput) SetIsAudio(v bool) *PreviewVideoForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *PreviewVideoForGetAITranslationProjectOutput) SetUri(v string) *PreviewVideoForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *PreviewVideoForGetAITranslationProjectOutput) SetUrl(v string) *PreviewVideoForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *PreviewVideoForGetAITranslationProjectOutput) SetVid(v string) *PreviewVideoForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type PreviewVideoMutedForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PreviewVideoMutedForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PreviewVideoMutedForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *PreviewVideoMutedForGetAITranslationProjectOutput) SetDurationSecond(v float64) *PreviewVideoMutedForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *PreviewVideoMutedForGetAITranslationProjectOutput) SetIsAudio(v bool) *PreviewVideoMutedForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *PreviewVideoMutedForGetAITranslationProjectOutput) SetUri(v string) *PreviewVideoMutedForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *PreviewVideoMutedForGetAITranslationProjectOutput) SetUrl(v string) *PreviewVideoMutedForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *PreviewVideoMutedForGetAITranslationProjectOutput) SetVid(v string) *PreviewVideoMutedForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}

type ProjectInfoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackgroundAudio *BackgroundAudioForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	BackgroundClip *BackgroundClipForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	CreatedAt *string `type:"string" json:",omitempty"`

	ErasedSubtitleVideo *ErasedSubtitleVideoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	ErrorCode *int32 `type:"int32" json:",omitempty"`

	ErrorMsg *string `type:"string" json:",omitempty"`

	FacialTranslationVideo *FacialTranslationVideoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	ForegroundAudio *ForegroundAudioForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	InputVideo *InputVideoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	InputVideoTitle *string `type:"string" json:",omitempty"`

	OperatorConfig *OperatorConfigForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	OutputVideo *OutputVideoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	PreviewVideo *PreviewVideoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	PreviewVideoMuted *PreviewVideoMutedForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	ProjectVersion *string `type:"string" json:",omitempty"`

	SourceBlueprints []*SourceBlueprintForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	SourceClips []*SourceClipForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	SourceTracks []*SourceTrackForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	SourceUtterances []*SourceUtteranceForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	Speakers []*SpeakerForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	TargetBlueprints []*TargetBlueprintForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	TargetClips []*TargetClipForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	TargetTracks []*TargetTrackForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	TargetUtterances []*TargetUtteranceForGetAITranslationProjectOutput `type:"list" json:",omitempty"`

	TranslationTypeList []*string `type:"list" json:",omitempty"`

	UpdatedAt *string `type:"string" json:",omitempty"`

	VoiceTranslationVideo *VoiceTranslationVideoForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	WorkflowId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ProjectInfoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectInfoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetBackgroundAudio sets the BackgroundAudio field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetBackgroundAudio(v *BackgroundAudioForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.BackgroundAudio = v
	return s
}

// SetBackgroundClip sets the BackgroundClip field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetBackgroundClip(v *BackgroundClipForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.BackgroundClip = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetCreatedAt(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.CreatedAt = &v
	return s
}

// SetErasedSubtitleVideo sets the ErasedSubtitleVideo field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetErasedSubtitleVideo(v *ErasedSubtitleVideoForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.ErasedSubtitleVideo = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetErrorCode(v int32) *ProjectInfoForGetAITranslationProjectOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorMsg sets the ErrorMsg field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetErrorMsg(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.ErrorMsg = &v
	return s
}

// SetFacialTranslationVideo sets the FacialTranslationVideo field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetFacialTranslationVideo(v *FacialTranslationVideoForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.FacialTranslationVideo = v
	return s
}

// SetForegroundAudio sets the ForegroundAudio field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetForegroundAudio(v *ForegroundAudioForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.ForegroundAudio = v
	return s
}

// SetInputVideo sets the InputVideo field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetInputVideo(v *InputVideoForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.InputVideo = v
	return s
}

// SetInputVideoTitle sets the InputVideoTitle field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetInputVideoTitle(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.InputVideoTitle = &v
	return s
}

// SetOperatorConfig sets the OperatorConfig field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetOperatorConfig(v *OperatorConfigForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.OperatorConfig = v
	return s
}

// SetOutputVideo sets the OutputVideo field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetOutputVideo(v *OutputVideoForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.OutputVideo = v
	return s
}

// SetPreviewVideo sets the PreviewVideo field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetPreviewVideo(v *PreviewVideoForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.PreviewVideo = v
	return s
}

// SetPreviewVideoMuted sets the PreviewVideoMuted field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetPreviewVideoMuted(v *PreviewVideoMutedForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.PreviewVideoMuted = v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetProjectId(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetProjectVersion sets the ProjectVersion field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetProjectVersion(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.ProjectVersion = &v
	return s
}

// SetSourceBlueprints sets the SourceBlueprints field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetSourceBlueprints(v []*SourceBlueprintForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.SourceBlueprints = v
	return s
}

// SetSourceClips sets the SourceClips field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetSourceClips(v []*SourceClipForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.SourceClips = v
	return s
}

// SetSourceTracks sets the SourceTracks field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetSourceTracks(v []*SourceTrackForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.SourceTracks = v
	return s
}

// SetSourceUtterances sets the SourceUtterances field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetSourceUtterances(v []*SourceUtteranceForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.SourceUtterances = v
	return s
}

// SetSpeakers sets the Speakers field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetSpeakers(v []*SpeakerForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.Speakers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetStatus(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.Status = &v
	return s
}

// SetTargetBlueprints sets the TargetBlueprints field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetTargetBlueprints(v []*TargetBlueprintForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.TargetBlueprints = v
	return s
}

// SetTargetClips sets the TargetClips field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetTargetClips(v []*TargetClipForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.TargetClips = v
	return s
}

// SetTargetTracks sets the TargetTracks field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetTargetTracks(v []*TargetTrackForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.TargetTracks = v
	return s
}

// SetTargetUtterances sets the TargetUtterances field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetTargetUtterances(v []*TargetUtteranceForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.TargetUtterances = v
	return s
}

// SetTranslationTypeList sets the TranslationTypeList field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetTranslationTypeList(v []*string) *ProjectInfoForGetAITranslationProjectOutput {
	s.TranslationTypeList = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetUpdatedAt(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.UpdatedAt = &v
	return s
}

// SetVoiceTranslationVideo sets the VoiceTranslationVideo field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetVoiceTranslationVideo(v *VoiceTranslationVideoForGetAITranslationProjectOutput) *ProjectInfoForGetAITranslationProjectOutput {
	s.VoiceTranslationVideo = v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *ProjectInfoForGetAITranslationProjectOutput) SetWorkflowId(v string) *ProjectInfoForGetAITranslationProjectOutput {
	s.WorkflowId = &v
	return s
}

type SourceBlueprintForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Language *string `type:"string" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SourceBlueprintForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceBlueprintForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *SourceBlueprintForGetAITranslationProjectOutput) SetId(v string) *SourceBlueprintForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SourceBlueprintForGetAITranslationProjectOutput) SetLanguage(v string) *SourceBlueprintForGetAITranslationProjectOutput {
	s.Language = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *SourceBlueprintForGetAITranslationProjectOutput) SetProjectId(v string) *SourceBlueprintForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *SourceBlueprintForGetAITranslationProjectOutput) SetTranslationType(v string) *SourceBlueprintForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type SourceClipForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClipAudio *PreviewVideoMutedForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	ClipVideo *PreviewVideoMutedForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	TrackId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`

	Trim *TrimForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	Volume *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s SourceClipForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceClipForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetClipAudio sets the ClipAudio field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetClipAudio(v *PreviewVideoMutedForGetAITranslationProjectOutput) *SourceClipForGetAITranslationProjectOutput {
	s.ClipAudio = v
	return s
}

// SetClipVideo sets the ClipVideo field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetClipVideo(v *PreviewVideoMutedForGetAITranslationProjectOutput) *SourceClipForGetAITranslationProjectOutput {
	s.ClipVideo = v
	return s
}

// SetId sets the Id field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetId(v string) *SourceClipForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetTrackId sets the TrackId field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetTrackId(v string) *SourceClipForGetAITranslationProjectOutput {
	s.TrackId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetTranslationType(v string) *SourceClipForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

// SetTrim sets the Trim field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetTrim(v *TrimForGetAITranslationProjectOutput) *SourceClipForGetAITranslationProjectOutput {
	s.Trim = v
	return s
}

// SetVolume sets the Volume field's value.
func (s *SourceClipForGetAITranslationProjectOutput) SetVolume(v int32) *SourceClipForGetAITranslationProjectOutput {
	s.Volume = &v
	return s
}

type SourceTrackForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BlueprintId *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SpeakerId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SourceTrackForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceTrackForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *SourceTrackForGetAITranslationProjectOutput) SetBlueprintId(v string) *SourceTrackForGetAITranslationProjectOutput {
	s.BlueprintId = &v
	return s
}

// SetId sets the Id field's value.
func (s *SourceTrackForGetAITranslationProjectOutput) SetId(v string) *SourceTrackForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *SourceTrackForGetAITranslationProjectOutput) SetSpeakerId(v string) *SourceTrackForGetAITranslationProjectOutput {
	s.SpeakerId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *SourceTrackForGetAITranslationProjectOutput) SetTranslationType(v string) *SourceTrackForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type SourceUtteranceForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BlueprintId *string `type:"string" json:",omitempty"`

	ClipId *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	IsFacialTranslation *bool `type:"boolean" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	SourceId *string `type:"string" json:",omitempty"`

	SpeakerId *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	Text *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SourceUtteranceForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceUtteranceForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetBlueprintId(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.BlueprintId = &v
	return s
}

// SetClipId sets the ClipId field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetClipId(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.ClipId = &v
	return s
}

// SetId sets the Id field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetId(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetIsFacialTranslation sets the IsFacialTranslation field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetIsFacialTranslation(v bool) *SourceUtteranceForGetAITranslationProjectOutput {
	s.IsFacialTranslation = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetProjectId(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetSourceId(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.SourceId = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetSpeakerId(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.SpeakerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetStatus(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.Status = &v
	return s
}

// SetText sets the Text field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetText(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.Text = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *SourceUtteranceForGetAITranslationProjectOutput) SetTranslationType(v string) *SourceUtteranceForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type SpeakerForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	Voice *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SpeakerForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SpeakerForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *SpeakerForGetAITranslationProjectOutput) SetId(v string) *SpeakerForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *SpeakerForGetAITranslationProjectOutput) SetName(v string) *SpeakerForGetAITranslationProjectOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *SpeakerForGetAITranslationProjectOutput) SetProjectId(v string) *SpeakerForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetVoice sets the Voice field's value.
func (s *SpeakerForGetAITranslationProjectOutput) SetVoice(v string) *SpeakerForGetAITranslationProjectOutput {
	s.Voice = &v
	return s
}

type SubtitleRecognitionConfigForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RecognitionType *string `type:"string" json:",omitempty"`

	SubtitleFileName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SubtitleRecognitionConfigForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubtitleRecognitionConfigForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetRecognitionType sets the RecognitionType field's value.
func (s *SubtitleRecognitionConfigForGetAITranslationProjectOutput) SetRecognitionType(v string) *SubtitleRecognitionConfigForGetAITranslationProjectOutput {
	s.RecognitionType = &v
	return s
}

// SetSubtitleFileName sets the SubtitleFileName field's value.
func (s *SubtitleRecognitionConfigForGetAITranslationProjectOutput) SetSubtitleFileName(v string) *SubtitleRecognitionConfigForGetAITranslationProjectOutput {
	s.SubtitleFileName = &v
	return s
}

type TargetBlueprintForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Language *string `type:"string" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetBlueprintForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetBlueprintForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TargetBlueprintForGetAITranslationProjectOutput) SetId(v string) *TargetBlueprintForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *TargetBlueprintForGetAITranslationProjectOutput) SetLanguage(v string) *TargetBlueprintForGetAITranslationProjectOutput {
	s.Language = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *TargetBlueprintForGetAITranslationProjectOutput) SetProjectId(v string) *TargetBlueprintForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *TargetBlueprintForGetAITranslationProjectOutput) SetTranslationType(v string) *TargetBlueprintForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type TargetClipForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClipAudio *PreviewVideoMutedForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	ClipVideo *PreviewVideoMutedForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	TrackId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`

	Trim *TrimForGetAITranslationProjectOutput `type:"structure" json:",omitempty"`

	Volume *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TargetClipForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetClipForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetClipAudio sets the ClipAudio field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetClipAudio(v *PreviewVideoMutedForGetAITranslationProjectOutput) *TargetClipForGetAITranslationProjectOutput {
	s.ClipAudio = v
	return s
}

// SetClipVideo sets the ClipVideo field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetClipVideo(v *PreviewVideoMutedForGetAITranslationProjectOutput) *TargetClipForGetAITranslationProjectOutput {
	s.ClipVideo = v
	return s
}

// SetId sets the Id field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetId(v string) *TargetClipForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetTrackId sets the TrackId field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetTrackId(v string) *TargetClipForGetAITranslationProjectOutput {
	s.TrackId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetTranslationType(v string) *TargetClipForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

// SetTrim sets the Trim field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetTrim(v *TrimForGetAITranslationProjectOutput) *TargetClipForGetAITranslationProjectOutput {
	s.Trim = v
	return s
}

// SetVolume sets the Volume field's value.
func (s *TargetClipForGetAITranslationProjectOutput) SetVolume(v int32) *TargetClipForGetAITranslationProjectOutput {
	s.Volume = &v
	return s
}

type TargetTrackForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BlueprintId *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SpeakerId *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetTrackForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetTrackForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *TargetTrackForGetAITranslationProjectOutput) SetBlueprintId(v string) *TargetTrackForGetAITranslationProjectOutput {
	s.BlueprintId = &v
	return s
}

// SetId sets the Id field's value.
func (s *TargetTrackForGetAITranslationProjectOutput) SetId(v string) *TargetTrackForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *TargetTrackForGetAITranslationProjectOutput) SetSpeakerId(v string) *TargetTrackForGetAITranslationProjectOutput {
	s.SpeakerId = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *TargetTrackForGetAITranslationProjectOutput) SetTranslationType(v string) *TargetTrackForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type TargetUtteranceForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BlueprintId *string `type:"string" json:",omitempty"`

	ClipId *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	IsFacialTranslation *bool `type:"boolean" json:",omitempty"`

	ProjectId *string `type:"string" json:",omitempty"`

	SourceId *string `type:"string" json:",omitempty"`

	SpeakerId *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	Text *string `type:"string" json:",omitempty"`

	TranslationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetUtteranceForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetUtteranceForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetBlueprintId(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.BlueprintId = &v
	return s
}

// SetClipId sets the ClipId field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetClipId(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.ClipId = &v
	return s
}

// SetId sets the Id field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetId(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.Id = &v
	return s
}

// SetIsFacialTranslation sets the IsFacialTranslation field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetIsFacialTranslation(v bool) *TargetUtteranceForGetAITranslationProjectOutput {
	s.IsFacialTranslation = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetProjectId(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.ProjectId = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetSourceId(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.SourceId = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetSpeakerId(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.SpeakerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetStatus(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.Status = &v
	return s
}

// SetText sets the Text field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetText(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.Text = &v
	return s
}

// SetTranslationType sets the TranslationType field's value.
func (s *TargetUtteranceForGetAITranslationProjectOutput) SetTranslationType(v string) *TargetUtteranceForGetAITranslationProjectOutput {
	s.TranslationType = &v
	return s
}

type TrimForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	End *int32 `type:"int32" json:",omitempty"`

	Start *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TrimForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TrimForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *TrimForGetAITranslationProjectOutput) SetEnd(v int32) *TrimForGetAITranslationProjectOutput {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *TrimForGetAITranslationProjectOutput) SetStart(v int32) *TrimForGetAITranslationProjectOutput {
	s.Start = &v
	return s
}

type VoiceTranslationVideoForGetAITranslationProjectOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DurationSecond *float64 `type:"double" json:",omitempty"`

	IsAudio *bool `type:"boolean" json:",omitempty"`

	Uri *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VoiceTranslationVideoForGetAITranslationProjectOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceTranslationVideoForGetAITranslationProjectOutput) GoString() string {
	return s.String()
}

// SetDurationSecond sets the DurationSecond field's value.
func (s *VoiceTranslationVideoForGetAITranslationProjectOutput) SetDurationSecond(v float64) *VoiceTranslationVideoForGetAITranslationProjectOutput {
	s.DurationSecond = &v
	return s
}

// SetIsAudio sets the IsAudio field's value.
func (s *VoiceTranslationVideoForGetAITranslationProjectOutput) SetIsAudio(v bool) *VoiceTranslationVideoForGetAITranslationProjectOutput {
	s.IsAudio = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *VoiceTranslationVideoForGetAITranslationProjectOutput) SetUri(v string) *VoiceTranslationVideoForGetAITranslationProjectOutput {
	s.Uri = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *VoiceTranslationVideoForGetAITranslationProjectOutput) SetUrl(v string) *VoiceTranslationVideoForGetAITranslationProjectOutput {
	s.Url = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *VoiceTranslationVideoForGetAITranslationProjectOutput) SetVid(v string) *VoiceTranslationVideoForGetAITranslationProjectOutput {
	s.Vid = &v
	return s
}
