// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateNumberPoolV2Common = "UpdateNumberPoolV2"

// UpdateNumberPoolV2CommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateNumberPoolV2Common operation. The "output" return
// value will be populated with the UpdateNumberPoolV2Common request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateNumberPoolV2Common Request to send the API call to the service.
// the "output" return value is not valid until after UpdateNumberPoolV2Common Send returns without error.
//
// See UpdateNumberPoolV2Common for more information on using the UpdateNumberPoolV2Common
// API call, and error handling.
//
//    // Example sending a request using the UpdateNumberPoolV2CommonRequest method.
//    req, resp := client.UpdateNumberPoolV2CommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) UpdateNumberPoolV2CommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateNumberPoolV2Common,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateNumberPoolV2Common API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation UpdateNumberPoolV2Common for usage and error information.
func (c *VMS) UpdateNumberPoolV2Common(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateNumberPoolV2CommonRequest(input)
	return out, req.Send()
}

// UpdateNumberPoolV2CommonWithContext is the same as UpdateNumberPoolV2Common with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNumberPoolV2Common for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) UpdateNumberPoolV2CommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateNumberPoolV2CommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNumberPoolV2 = "UpdateNumberPoolV2"

// UpdateNumberPoolV2Request generates a "volcengine/request.Request" representing the
// client's request for the UpdateNumberPoolV2 operation. The "output" return
// value will be populated with the UpdateNumberPoolV2Common request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateNumberPoolV2Common Request to send the API call to the service.
// the "output" return value is not valid until after UpdateNumberPoolV2Common Send returns without error.
//
// See UpdateNumberPoolV2 for more information on using the UpdateNumberPoolV2
// API call, and error handling.
//
//    // Example sending a request using the UpdateNumberPoolV2Request method.
//    req, resp := client.UpdateNumberPoolV2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) UpdateNumberPoolV2Request(input *UpdateNumberPoolV2Input) (req *request.Request, output *UpdateNumberPoolV2Output) {
	op := &request.Operation{
		Name:       opUpdateNumberPoolV2,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNumberPoolV2Input{}
	}

	output = &UpdateNumberPoolV2Output{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateNumberPoolV2 API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation UpdateNumberPoolV2 for usage and error information.
func (c *VMS) UpdateNumberPoolV2(input *UpdateNumberPoolV2Input) (*UpdateNumberPoolV2Output, error) {
	req, out := c.UpdateNumberPoolV2Request(input)
	return out, req.Send()
}

// UpdateNumberPoolV2WithContext is the same as UpdateNumberPoolV2 with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNumberPoolV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) UpdateNumberPoolV2WithContext(ctx volcengine.Context, input *UpdateNumberPoolV2Input, opts ...request.Option) (*UpdateNumberPoolV2Output, error) {
	req, out := c.UpdateNumberPoolV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateNumberPoolV2Input struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"31" type:"string" json:",omitempty" required:"true"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	ServiceType *int32 `type:"int32" json:",omitempty"`

	SubServiceType *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s UpdateNumberPoolV2Input) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNumberPoolV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNumberPoolV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNumberPoolV2Input"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 31, *s.Name))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateNumberPoolV2Input) SetName(v string) *UpdateNumberPoolV2Input {
	s.Name = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *UpdateNumberPoolV2Input) SetNumberPoolNo(v string) *UpdateNumberPoolV2Input {
	s.NumberPoolNo = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *UpdateNumberPoolV2Input) SetServiceType(v int32) *UpdateNumberPoolV2Input {
	s.ServiceType = &v
	return s
}

// SetSubServiceType sets the SubServiceType field's value.
func (s *UpdateNumberPoolV2Input) SetSubServiceType(v int32) *UpdateNumberPoolV2Input {
	s.SubServiceType = &v
	return s
}

type UpdateNumberPoolV2Output struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Success *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s UpdateNumberPoolV2Output) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNumberPoolV2Output) GoString() string {
	return s.String()
}

// SetSuccess sets the Success field's value.
func (s *UpdateNumberPoolV2Output) SetSuccess(v bool) *UpdateNumberPoolV2Output {
	s.Success = &v
	return s
}
