// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUnbindAXNV2Common = "UnbindAXNV2"

// UnbindAXNV2CommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UnbindAXNV2Common operation. The "output" return
// value will be populated with the UnbindAXNV2Common request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UnbindAXNV2Common Request to send the API call to the service.
// the "output" return value is not valid until after UnbindAXNV2Common Send returns without error.
//
// See UnbindAXNV2Common for more information on using the UnbindAXNV2Common
// API call, and error handling.
//
//    // Example sending a request using the UnbindAXNV2CommonRequest method.
//    req, resp := client.UnbindAXNV2CommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) UnbindAXNV2CommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUnbindAXNV2Common,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UnbindAXNV2Common API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation UnbindAXNV2Common for usage and error information.
func (c *VMS) UnbindAXNV2Common(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UnbindAXNV2CommonRequest(input)
	return out, req.Send()
}

// UnbindAXNV2CommonWithContext is the same as UnbindAXNV2Common with the addition of
// the ability to pass a context and additional request options.
//
// See UnbindAXNV2Common for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) UnbindAXNV2CommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UnbindAXNV2CommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnbindAXNV2 = "UnbindAXNV2"

// UnbindAXNV2Request generates a "volcengine/request.Request" representing the
// client's request for the UnbindAXNV2 operation. The "output" return
// value will be populated with the UnbindAXNV2Common request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UnbindAXNV2Common Request to send the API call to the service.
// the "output" return value is not valid until after UnbindAXNV2Common Send returns without error.
//
// See UnbindAXNV2 for more information on using the UnbindAXNV2
// API call, and error handling.
//
//    // Example sending a request using the UnbindAXNV2Request method.
//    req, resp := client.UnbindAXNV2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) UnbindAXNV2Request(input *UnbindAXNV2Input) (req *request.Request, output *UnbindAXNV2Output) {
	op := &request.Operation{
		Name:       opUnbindAXNV2,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnbindAXNV2Input{}
	}

	output = &UnbindAXNV2Output{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UnbindAXNV2 API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation UnbindAXNV2 for usage and error information.
func (c *VMS) UnbindAXNV2(input *UnbindAXNV2Input) (*UnbindAXNV2Output, error) {
	req, out := c.UnbindAXNV2Request(input)
	return out, req.Send()
}

// UnbindAXNV2WithContext is the same as UnbindAXNV2 with the addition of
// the ability to pass a context and additional request options.
//
// See UnbindAXNV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) UnbindAXNV2WithContext(ctx volcengine.Context, input *UnbindAXNV2Input, opts ...request.Option) (*UnbindAXNV2Output, error) {
	req, out := c.UnbindAXNV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UnbindAXNV2Input struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	// SubId is a required field
	SubId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s UnbindAXNV2Input) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UnbindAXNV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnbindAXNV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnbindAXNV2Input"}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.SubId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *UnbindAXNV2Input) SetNumberPoolNo(v string) *UnbindAXNV2Input {
	s.NumberPoolNo = &v
	return s
}

// SetSubId sets the SubId field's value.
func (s *UnbindAXNV2Input) SetSubId(v string) *UnbindAXNV2Input {
	s.SubId = &v
	return s
}

type UnbindAXNV2Output struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Success *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s UnbindAXNV2Output) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UnbindAXNV2Output) GoString() string {
	return s.String()
}

// SetSuccess sets the Success field's value.
func (s *UnbindAXNV2Output) SetSuccess(v bool) *UnbindAXNV2Output {
	s.Success = &v
	return s
}
