// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opNumberListCommon = "NumberList"

// NumberListCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the NumberListCommon operation. The "output" return
// value will be populated with the NumberListCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned NumberListCommon Request to send the API call to the service.
// the "output" return value is not valid until after NumberListCommon Send returns without error.
//
// See NumberListCommon for more information on using the NumberListCommon
// API call, and error handling.
//
//    // Example sending a request using the NumberListCommonRequest method.
//    req, resp := client.NumberListCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) NumberListCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opNumberListCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// NumberListCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation NumberListCommon for usage and error information.
func (c *VMS) NumberListCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.NumberListCommonRequest(input)
	return out, req.Send()
}

// NumberListCommonWithContext is the same as NumberListCommon with the addition of
// the ability to pass a context and additional request options.
//
// See NumberListCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) NumberListCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.NumberListCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opNumberList = "NumberList"

// NumberListRequest generates a "volcengine/request.Request" representing the
// client's request for the NumberList operation. The "output" return
// value will be populated with the NumberListCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned NumberListCommon Request to send the API call to the service.
// the "output" return value is not valid until after NumberListCommon Send returns without error.
//
// See NumberList for more information on using the NumberList
// API call, and error handling.
//
//    // Example sending a request using the NumberListRequest method.
//    req, resp := client.NumberListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) NumberListRequest(input *NumberListInput) (req *request.Request, output *NumberListOutput) {
	op := &request.Operation{
		Name:       opNumberList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NumberListInput{}
	}

	output = &NumberListOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// NumberList API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation NumberList for usage and error information.
func (c *VMS) NumberList(input *NumberListInput) (*NumberListOutput, error) {
	req, out := c.NumberListRequest(input)
	return out, req.Send()
}

// NumberListWithContext is the same as NumberList with the addition of
// the ability to pass a context and additional request options.
//
// See NumberList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) NumberListWithContext(ctx volcengine.Context, input *NumberListInput, opts ...request.Option) (*NumberListOutput, error) {
	req, out := c.NumberListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type NumberListInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Limit *int32 `type:"int32" json:",omitempty"`

	NumberList []*string `type:"list" json:",omitempty"`

	NumberPoolNo *string `type:"string" json:",omitempty"`

	NumberPoolTypeCode *int32 `type:"int32" json:",omitempty"`

	NumberStatusCode *int32 `type:"int32" json:",omitempty"`

	NumberTypeCode *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s NumberListInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberListInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *NumberListInput) SetLimit(v int32) *NumberListInput {
	s.Limit = &v
	return s
}

// SetNumberList sets the NumberList field's value.
func (s *NumberListInput) SetNumberList(v []*string) *NumberListInput {
	s.NumberList = v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *NumberListInput) SetNumberPoolNo(v string) *NumberListInput {
	s.NumberPoolNo = &v
	return s
}

// SetNumberPoolTypeCode sets the NumberPoolTypeCode field's value.
func (s *NumberListInput) SetNumberPoolTypeCode(v int32) *NumberListInput {
	s.NumberPoolTypeCode = &v
	return s
}

// SetNumberStatusCode sets the NumberStatusCode field's value.
func (s *NumberListInput) SetNumberStatusCode(v int32) *NumberListInput {
	s.NumberStatusCode = &v
	return s
}

// SetNumberTypeCode sets the NumberTypeCode field's value.
func (s *NumberListInput) SetNumberTypeCode(v int32) *NumberListInput {
	s.NumberTypeCode = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *NumberListInput) SetOffset(v int32) *NumberListInput {
	s.Offset = &v
	return s
}

type NumberListOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Limit *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	Records []*RecordForNumberListOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s NumberListOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberListOutput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *NumberListOutput) SetLimit(v int32) *NumberListOutput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *NumberListOutput) SetOffset(v int32) *NumberListOutput {
	s.Offset = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *NumberListOutput) SetRecords(v []*RecordForNumberListOutput) *NumberListOutput {
	s.Records = v
	return s
}

// SetTotal sets the Total field's value.
func (s *NumberListOutput) SetTotal(v int32) *NumberListOutput {
	s.Total = &v
	return s
}

type RecordForNumberListOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CurrentBindCount *int32 `type:"int32" json:",omitempty"`

	Number *string `type:"string" json:",omitempty"`

	NumberLocation *string `type:"string" json:",omitempty"`

	NumberPoolName *string `type:"string" json:",omitempty"`

	NumberPoolNo *string `type:"string" json:",omitempty"`

	NumberPoolTypeCode *int32 `type:"int32" json:",omitempty"`

	NumberPoolTypeDesc *string `type:"string" json:",omitempty"`

	NumberPurchaseTime *string `type:"string" json:",omitempty"`

	NumberStatusCode *int32 `type:"int32" json:",omitempty"`

	NumberStatusDesc *string `type:"string" json:",omitempty"`

	NumberTypeCode *int32 `type:"int32" json:",omitempty"`

	NumberTypeDesc *string `type:"string" json:",omitempty"`

	QualificationNo *string `type:"string" json:",omitempty"`

	ServiceTypeCode *int32 `type:"int32" json:",omitempty"`

	ServiceTypeDesc *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RecordForNumberListOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordForNumberListOutput) GoString() string {
	return s.String()
}

// SetCurrentBindCount sets the CurrentBindCount field's value.
func (s *RecordForNumberListOutput) SetCurrentBindCount(v int32) *RecordForNumberListOutput {
	s.CurrentBindCount = &v
	return s
}

// SetNumber sets the Number field's value.
func (s *RecordForNumberListOutput) SetNumber(v string) *RecordForNumberListOutput {
	s.Number = &v
	return s
}

// SetNumberLocation sets the NumberLocation field's value.
func (s *RecordForNumberListOutput) SetNumberLocation(v string) *RecordForNumberListOutput {
	s.NumberLocation = &v
	return s
}

// SetNumberPoolName sets the NumberPoolName field's value.
func (s *RecordForNumberListOutput) SetNumberPoolName(v string) *RecordForNumberListOutput {
	s.NumberPoolName = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *RecordForNumberListOutput) SetNumberPoolNo(v string) *RecordForNumberListOutput {
	s.NumberPoolNo = &v
	return s
}

// SetNumberPoolTypeCode sets the NumberPoolTypeCode field's value.
func (s *RecordForNumberListOutput) SetNumberPoolTypeCode(v int32) *RecordForNumberListOutput {
	s.NumberPoolTypeCode = &v
	return s
}

// SetNumberPoolTypeDesc sets the NumberPoolTypeDesc field's value.
func (s *RecordForNumberListOutput) SetNumberPoolTypeDesc(v string) *RecordForNumberListOutput {
	s.NumberPoolTypeDesc = &v
	return s
}

// SetNumberPurchaseTime sets the NumberPurchaseTime field's value.
func (s *RecordForNumberListOutput) SetNumberPurchaseTime(v string) *RecordForNumberListOutput {
	s.NumberPurchaseTime = &v
	return s
}

// SetNumberStatusCode sets the NumberStatusCode field's value.
func (s *RecordForNumberListOutput) SetNumberStatusCode(v int32) *RecordForNumberListOutput {
	s.NumberStatusCode = &v
	return s
}

// SetNumberStatusDesc sets the NumberStatusDesc field's value.
func (s *RecordForNumberListOutput) SetNumberStatusDesc(v string) *RecordForNumberListOutput {
	s.NumberStatusDesc = &v
	return s
}

// SetNumberTypeCode sets the NumberTypeCode field's value.
func (s *RecordForNumberListOutput) SetNumberTypeCode(v int32) *RecordForNumberListOutput {
	s.NumberTypeCode = &v
	return s
}

// SetNumberTypeDesc sets the NumberTypeDesc field's value.
func (s *RecordForNumberListOutput) SetNumberTypeDesc(v string) *RecordForNumberListOutput {
	s.NumberTypeDesc = &v
	return s
}

// SetQualificationNo sets the QualificationNo field's value.
func (s *RecordForNumberListOutput) SetQualificationNo(v string) *RecordForNumberListOutput {
	s.QualificationNo = &v
	return s
}

// SetServiceTypeCode sets the ServiceTypeCode field's value.
func (s *RecordForNumberListOutput) SetServiceTypeCode(v int32) *RecordForNumberListOutput {
	s.ServiceTypeCode = &v
	return s
}

// SetServiceTypeDesc sets the ServiceTypeDesc field's value.
func (s *RecordForNumberListOutput) SetServiceTypeDesc(v string) *RecordForNumberListOutput {
	s.ServiceTypeDesc = &v
	return s
}
