// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNumberPoolCommon = "CreateNumberPool"

// CreateNumberPoolCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNumberPoolCommon operation. The "output" return
// value will be populated with the CreateNumberPoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNumberPoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNumberPoolCommon Send returns without error.
//
// See CreateNumberPoolCommon for more information on using the CreateNumberPoolCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNumberPoolCommonRequest method.
//    req, resp := client.CreateNumberPoolCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) CreateNumberPoolCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNumberPoolCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNumberPoolCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation CreateNumberPoolCommon for usage and error information.
func (c *VMS) CreateNumberPoolCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNumberPoolCommonRequest(input)
	return out, req.Send()
}

// CreateNumberPoolCommonWithContext is the same as CreateNumberPoolCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNumberPoolCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) CreateNumberPoolCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNumberPoolCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNumberPool = "CreateNumberPool"

// CreateNumberPoolRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNumberPool operation. The "output" return
// value will be populated with the CreateNumberPoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNumberPoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNumberPoolCommon Send returns without error.
//
// See CreateNumberPool for more information on using the CreateNumberPool
// API call, and error handling.
//
//    // Example sending a request using the CreateNumberPoolRequest method.
//    req, resp := client.CreateNumberPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) CreateNumberPoolRequest(input *CreateNumberPoolInput) (req *request.Request, output *CreateNumberPoolOutput) {
	op := &request.Operation{
		Name:       opCreateNumberPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNumberPoolInput{}
	}

	output = &CreateNumberPoolOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNumberPool API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation CreateNumberPool for usage and error information.
func (c *VMS) CreateNumberPool(input *CreateNumberPoolInput) (*CreateNumberPoolOutput, error) {
	req, out := c.CreateNumberPoolRequest(input)
	return out, req.Send()
}

// CreateNumberPoolWithContext is the same as CreateNumberPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNumberPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) CreateNumberPoolWithContext(ctx volcengine.Context, input *CreateNumberPoolInput, opts ...request.Option) (*CreateNumberPoolOutput, error) {
	req, out := c.CreateNumberPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateNumberPoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"32" type:"string" json:",omitempty" required:"true"`

	// ServiceType is a required field
	ServiceType *int32 `type:"int32" json:",omitempty" required:"true"`

	// SubServiceType is a required field
	SubServiceType *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateNumberPoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNumberPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNumberPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNumberPoolInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 32 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 32, *s.Name))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.SubServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SubServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateNumberPoolInput) SetName(v string) *CreateNumberPoolInput {
	s.Name = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *CreateNumberPoolInput) SetServiceType(v int32) *CreateNumberPoolInput {
	s.ServiceType = &v
	return s
}

// SetSubServiceType sets the SubServiceType field's value.
func (s *CreateNumberPoolInput) SetSubServiceType(v int32) *CreateNumberPoolInput {
	s.SubServiceType = &v
	return s
}

type CreateNumberPoolOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Name *string `type:"string" json:",omitempty"`

	NumberPoolNo *string `type:"string" json:",omitempty"`

	ServiceType *int32 `type:"int32" json:",omitempty"`

	SubServiceType *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CreateNumberPoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNumberPoolOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateNumberPoolOutput) SetName(v string) *CreateNumberPoolOutput {
	s.Name = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *CreateNumberPoolOutput) SetNumberPoolNo(v string) *CreateNumberPoolOutput {
	s.NumberPoolNo = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *CreateNumberPoolOutput) SetServiceType(v int32) *CreateNumberPoolOutput {
	s.ServiceType = &v
	return s
}

// SetSubServiceType sets the SubServiceType field's value.
func (s *CreateNumberPoolOutput) SetSubServiceType(v int32) *CreateNumberPoolOutput {
	s.SubServiceType = &v
	return s
}
