// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opClick2CallCommon = "Click2Call"

// Click2CallCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the Click2CallCommon operation. The "output" return
// value will be populated with the Click2CallCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Click2CallCommon Request to send the API call to the service.
// the "output" return value is not valid until after Click2CallCommon Send returns without error.
//
// See Click2CallCommon for more information on using the Click2CallCommon
// API call, and error handling.
//
//    // Example sending a request using the Click2CallCommonRequest method.
//    req, resp := client.Click2CallCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) Click2CallCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opClick2CallCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// Click2CallCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation Click2CallCommon for usage and error information.
func (c *VMS) Click2CallCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.Click2CallCommonRequest(input)
	return out, req.Send()
}

// Click2CallCommonWithContext is the same as Click2CallCommon with the addition of
// the ability to pass a context and additional request options.
//
// See Click2CallCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) Click2CallCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.Click2CallCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClick2Call = "Click2Call"

// Click2CallRequest generates a "volcengine/request.Request" representing the
// client's request for the Click2Call operation. The "output" return
// value will be populated with the Click2CallCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Click2CallCommon Request to send the API call to the service.
// the "output" return value is not valid until after Click2CallCommon Send returns without error.
//
// See Click2Call for more information on using the Click2Call
// API call, and error handling.
//
//    // Example sending a request using the Click2CallRequest method.
//    req, resp := client.Click2CallRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) Click2CallRequest(input *Click2CallInput) (req *request.Request, output *Click2CallOutput) {
	op := &request.Operation{
		Name:       opClick2Call,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &Click2CallInput{}
	}

	output = &Click2CallOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// Click2Call API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation Click2Call for usage and error information.
func (c *VMS) Click2Call(input *Click2CallInput) (*Click2CallOutput, error) {
	req, out := c.Click2CallRequest(input)
	return out, req.Send()
}

// Click2CallWithContext is the same as Click2Call with the addition of
// the ability to pass a context and additional request options.
//
// See Click2Call for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) Click2CallWithContext(ctx volcengine.Context, input *Click2CallInput, opts ...request.Option) (*Click2CallOutput, error) {
	req, out := c.Click2CallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type Click2CallInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Callee is a required field
	Callee *string `type:"string" json:",omitempty" required:"true"`

	CalleeDegradeToCapital *int32 `type:"int32" json:",omitempty"`

	CalleeNumber *string `type:"string" json:",omitempty"`

	CalleeNumberCityCode *string `type:"string" json:",omitempty"`

	CalleeNumberDegradeCityList []*string `type:"list" json:",omitempty"`

	// CalleeNumberPoolNo is a required field
	CalleeNumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	// Caller is a required field
	Caller *string `type:"string" json:",omitempty" required:"true"`

	CallerDegradeToCapital *int32 `type:"int32" json:",omitempty"`

	CallerNumber *string `type:"string" json:",omitempty"`

	CallerNumberCityCode *string `type:"string" json:",omitempty"`

	CallerNumberDegradeCityList []*string `type:"list" json:",omitempty"`

	// CallerNumberPoolNo is a required field
	CallerNumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	LastMinutes *int32 `type:"int32" json:",omitempty"`

	LastVoice *string `type:"string" json:",omitempty"`

	LastVoiceTo *string `type:"string" json:",omitempty" enum:"EnumOfLastVoiceToForClick2CallInput"`

	MaxTime *int32 `type:"int32" json:",omitempty"`

	PreVoice *string `type:"string" json:",omitempty"`

	UserData *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s Click2CallInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Click2CallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Click2CallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Click2CallInput"}
	if s.Callee == nil {
		invalidParams.Add(request.NewErrParamRequired("Callee"))
	}
	if s.CalleeNumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("CalleeNumberPoolNo"))
	}
	if s.Caller == nil {
		invalidParams.Add(request.NewErrParamRequired("Caller"))
	}
	if s.CallerNumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerNumberPoolNo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallee sets the Callee field's value.
func (s *Click2CallInput) SetCallee(v string) *Click2CallInput {
	s.Callee = &v
	return s
}

// SetCalleeDegradeToCapital sets the CalleeDegradeToCapital field's value.
func (s *Click2CallInput) SetCalleeDegradeToCapital(v int32) *Click2CallInput {
	s.CalleeDegradeToCapital = &v
	return s
}

// SetCalleeNumber sets the CalleeNumber field's value.
func (s *Click2CallInput) SetCalleeNumber(v string) *Click2CallInput {
	s.CalleeNumber = &v
	return s
}

// SetCalleeNumberCityCode sets the CalleeNumberCityCode field's value.
func (s *Click2CallInput) SetCalleeNumberCityCode(v string) *Click2CallInput {
	s.CalleeNumberCityCode = &v
	return s
}

// SetCalleeNumberDegradeCityList sets the CalleeNumberDegradeCityList field's value.
func (s *Click2CallInput) SetCalleeNumberDegradeCityList(v []*string) *Click2CallInput {
	s.CalleeNumberDegradeCityList = v
	return s
}

// SetCalleeNumberPoolNo sets the CalleeNumberPoolNo field's value.
func (s *Click2CallInput) SetCalleeNumberPoolNo(v string) *Click2CallInput {
	s.CalleeNumberPoolNo = &v
	return s
}

// SetCaller sets the Caller field's value.
func (s *Click2CallInput) SetCaller(v string) *Click2CallInput {
	s.Caller = &v
	return s
}

// SetCallerDegradeToCapital sets the CallerDegradeToCapital field's value.
func (s *Click2CallInput) SetCallerDegradeToCapital(v int32) *Click2CallInput {
	s.CallerDegradeToCapital = &v
	return s
}

// SetCallerNumber sets the CallerNumber field's value.
func (s *Click2CallInput) SetCallerNumber(v string) *Click2CallInput {
	s.CallerNumber = &v
	return s
}

// SetCallerNumberCityCode sets the CallerNumberCityCode field's value.
func (s *Click2CallInput) SetCallerNumberCityCode(v string) *Click2CallInput {
	s.CallerNumberCityCode = &v
	return s
}

// SetCallerNumberDegradeCityList sets the CallerNumberDegradeCityList field's value.
func (s *Click2CallInput) SetCallerNumberDegradeCityList(v []*string) *Click2CallInput {
	s.CallerNumberDegradeCityList = v
	return s
}

// SetCallerNumberPoolNo sets the CallerNumberPoolNo field's value.
func (s *Click2CallInput) SetCallerNumberPoolNo(v string) *Click2CallInput {
	s.CallerNumberPoolNo = &v
	return s
}

// SetLastMinutes sets the LastMinutes field's value.
func (s *Click2CallInput) SetLastMinutes(v int32) *Click2CallInput {
	s.LastMinutes = &v
	return s
}

// SetLastVoice sets the LastVoice field's value.
func (s *Click2CallInput) SetLastVoice(v string) *Click2CallInput {
	s.LastVoice = &v
	return s
}

// SetLastVoiceTo sets the LastVoiceTo field's value.
func (s *Click2CallInput) SetLastVoiceTo(v string) *Click2CallInput {
	s.LastVoiceTo = &v
	return s
}

// SetMaxTime sets the MaxTime field's value.
func (s *Click2CallInput) SetMaxTime(v int32) *Click2CallInput {
	s.MaxTime = &v
	return s
}

// SetPreVoice sets the PreVoice field's value.
func (s *Click2CallInput) SetPreVoice(v string) *Click2CallInput {
	s.PreVoice = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *Click2CallInput) SetUserData(v string) *Click2CallInput {
	s.UserData = &v
	return s
}

type Click2CallOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CallId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s Click2CallOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Click2CallOutput) GoString() string {
	return s.String()
}

// SetCallId sets the CallId field's value.
func (s *Click2CallOutput) SetCallId(v string) *Click2CallOutput {
	s.CallId = &v
	return s
}

const (
	// EnumOfLastVoiceToForClick2CallInputNone is a EnumOfLastVoiceToForClick2CallInput enum value
	EnumOfLastVoiceToForClick2CallInputNone = "NONE"

	// EnumOfLastVoiceToForClick2CallInputCaller is a EnumOfLastVoiceToForClick2CallInput enum value
	EnumOfLastVoiceToForClick2CallInputCaller = "CALLER"

	// EnumOfLastVoiceToForClick2CallInputCallee is a EnumOfLastVoiceToForClick2CallInput enum value
	EnumOfLastVoiceToForClick2CallInputCallee = "CALLEE"

	// EnumOfLastVoiceToForClick2CallInputBoth is a EnumOfLastVoiceToForClick2CallInput enum value
	EnumOfLastVoiceToForClick2CallInputBoth = "BOTH"
)
