// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vke

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateAddonCommon = "CreateAddon"

// CreateAddonCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateAddonCommon operation. The "output" return
// value will be populated with the CreateAddonCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateAddonCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateAddonCommon Send returns without error.
//
// See CreateAddonCommon for more information on using the CreateAddonCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateAddonCommonRequest method.
//    req, resp := client.CreateAddonCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) CreateAddonCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateAddonCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateAddonCommon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation CreateAddonCommon for usage and error information.
func (c *VKE) CreateAddonCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateAddonCommonRequest(input)
	return out, req.Send()
}

// CreateAddonCommonWithContext is the same as CreateAddonCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddonCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) CreateAddonCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateAddonCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddon = "CreateAddon"

// CreateAddonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateAddon operation. The "output" return
// value will be populated with the CreateAddonCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateAddonCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateAddonCommon Send returns without error.
//
// See CreateAddon for more information on using the CreateAddon
// API call, and error handling.
//
//    // Example sending a request using the CreateAddonRequest method.
//    req, resp := client.CreateAddonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) CreateAddonRequest(input *CreateAddonInput) (req *request.Request, output *CreateAddonOutput) {
	op := &request.Operation{
		Name:       opCreateAddon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddonInput{}
	}

	output = &CreateAddonOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateAddon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation CreateAddon for usage and error information.
func (c *VKE) CreateAddon(input *CreateAddonInput) (*CreateAddonOutput, error) {
	req, out := c.CreateAddonRequest(input)
	return out, req.Send()
}

// CreateAddonWithContext is the same as CreateAddon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) CreateAddonWithContext(ctx volcengine.Context, input *CreateAddonInput, opts ...request.Option) (*CreateAddonOutput, error) {
	req, out := c.CreateAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateAddonInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	Config *string `type:"string" json:",omitempty"`

	DeployMode *string `type:"string" json:",omitempty" enum:"EnumOfDeployModeForCreateAddonInput"`

	DeployNodeType *string `type:"string" json:",omitempty" enum:"EnumOfDeployNodeTypeForCreateAddonInput"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	Version *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateAddonInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddonInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAddonInput) SetClientToken(v string) *CreateAddonInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateAddonInput) SetClusterId(v string) *CreateAddonInput {
	s.ClusterId = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *CreateAddonInput) SetConfig(v string) *CreateAddonInput {
	s.Config = &v
	return s
}

// SetDeployMode sets the DeployMode field's value.
func (s *CreateAddonInput) SetDeployMode(v string) *CreateAddonInput {
	s.DeployMode = &v
	return s
}

// SetDeployNodeType sets the DeployNodeType field's value.
func (s *CreateAddonInput) SetDeployNodeType(v string) *CreateAddonInput {
	s.DeployNodeType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAddonInput) SetName(v string) *CreateAddonInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateAddonInput) SetVersion(v string) *CreateAddonInput {
	s.Version = &v
	return s
}

type CreateAddonOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CreateAddonOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddonOutput) GoString() string {
	return s.String()
}

const (
	// EnumOfDeployModeForCreateAddonInputManaged is a EnumOfDeployModeForCreateAddonInput enum value
	EnumOfDeployModeForCreateAddonInputManaged = "Managed"

	// EnumOfDeployModeForCreateAddonInputUnmanaged is a EnumOfDeployModeForCreateAddonInput enum value
	EnumOfDeployModeForCreateAddonInputUnmanaged = "Unmanaged"
)

const (
	// EnumOfDeployNodeTypeForCreateAddonInputNode is a EnumOfDeployNodeTypeForCreateAddonInput enum value
	EnumOfDeployNodeTypeForCreateAddonInputNode = "Node"

	// EnumOfDeployNodeTypeForCreateAddonInputVirtualNode is a EnumOfDeployNodeTypeForCreateAddonInput enum value
	EnumOfDeployNodeTypeForCreateAddonInputVirtualNode = "VirtualNode"

	// EnumOfDeployNodeTypeForCreateAddonInputEdgeNode is a EnumOfDeployNodeTypeForCreateAddonInput enum value
	EnumOfDeployNodeTypeForCreateAddonInputEdgeNode = "EdgeNode"
)
