// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package veiapi

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListModelCommon = "ListModel"

// ListModelCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListModelCommon operation. The "output" return
// value will be populated with the ListModelCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListModelCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListModelCommon Send returns without error.
//
// See ListModelCommon for more information on using the ListModelCommon
// API call, and error handling.
//
//    // Example sending a request using the ListModelCommonRequest method.
//    req, resp := client.ListModelCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) ListModelCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListModelCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListModelCommon API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation ListModelCommon for usage and error information.
func (c *VEIAPI) ListModelCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListModelCommonRequest(input)
	return out, req.Send()
}

// ListModelCommonWithContext is the same as ListModelCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) ListModelCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListModelCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListModel = "ListModel"

// ListModelRequest generates a "volcengine/request.Request" representing the
// client's request for the ListModel operation. The "output" return
// value will be populated with the ListModelCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListModelCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListModelCommon Send returns without error.
//
// See ListModel for more information on using the ListModel
// API call, and error handling.
//
//    // Example sending a request using the ListModelRequest method.
//    req, resp := client.ListModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) ListModelRequest(input *ListModelInput) (req *request.Request, output *ListModelOutput) {
	op := &request.Operation{
		Name:       opListModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListModelInput{}
	}

	output = &ListModelOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListModel API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation ListModel for usage and error information.
func (c *VEIAPI) ListModel(input *ListModelInput) (*ListModelOutput, error) {
	req, out := c.ListModelRequest(input)
	return out, req.Send()
}

// ListModelWithContext is the same as ListModel with the addition of
// the ability to pass a context and additional request options.
//
// See ListModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) ListModelWithContext(ctx volcengine.Context, input *ListModelInput, opts ...request.Option) (*ListModelOutput, error) {
	req, out := c.ListModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListModelOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListModelOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListModelOutput) GoString() string {
	return s.String()
}

type ListModelInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Created_orderby *string `type:"string" json:"created_orderby,omitempty" enum:"EnumOfcreated_orderbyForListModelInput"`

	Kind *int32 `type:"int32" json:"kind,omitempty"`

	Model_name *string `type:"string" json:"model_name,omitempty"`

	// Page_index is a required field
	Page_index *int32 `type:"int32" json:"page_index,omitempty" required:"true"`

	// Page_size is a required field
	Page_size *int32 `type:"int32" json:"page_size,omitempty" required:"true"`

	Project_id *string `type:"string" json:"project_id,omitempty"`

	Updated_orderby *int32 `type:"int32" json:"updated_orderby,omitempty"`
}

// String returns the string representation
func (s ListModelInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelInput"}
	if s.Page_index == nil {
		invalidParams.Add(request.NewErrParamRequired("Page_index"))
	}
	if s.Page_size == nil {
		invalidParams.Add(request.NewErrParamRequired("Page_size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreated_orderby sets the Created_orderby field's value.
func (s *ListModelInput) SetCreated_orderby(v string) *ListModelInput {
	s.Created_orderby = &v
	return s
}

// SetKind sets the Kind field's value.
func (s *ListModelInput) SetKind(v int32) *ListModelInput {
	s.Kind = &v
	return s
}

// SetModel_name sets the Model_name field's value.
func (s *ListModelInput) SetModel_name(v string) *ListModelInput {
	s.Model_name = &v
	return s
}

// SetPage_index sets the Page_index field's value.
func (s *ListModelInput) SetPage_index(v int32) *ListModelInput {
	s.Page_index = &v
	return s
}

// SetPage_size sets the Page_size field's value.
func (s *ListModelInput) SetPage_size(v int32) *ListModelInput {
	s.Page_size = &v
	return s
}

// SetProject_id sets the Project_id field's value.
func (s *ListModelInput) SetProject_id(v string) *ListModelInput {
	s.Project_id = &v
	return s
}

// SetUpdated_orderby sets the Updated_orderby field's value.
func (s *ListModelInput) SetUpdated_orderby(v int32) *ListModelInput {
	s.Updated_orderby = &v
	return s
}

type ListModelOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListModelOutput `type:"list" json:"items,omitempty"`

	Kind *int32 `type:"int32" json:"kind,omitempty"`

	Pageinator *PageinatorForListModelOutput `type:"structure" json:"pageinator,omitempty"`
}

// String returns the string representation
func (s ListModelOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListModelOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListModelOutput) SetItems(v []*ItemForListModelOutput) *ListModelOutput {
	s.Items = v
	return s
}

// SetKind sets the Kind field's value.
func (s *ListModelOutput) SetKind(v int32) *ListModelOutput {
	s.Kind = &v
	return s
}

// SetPageinator sets the Pageinator field's value.
func (s *ListModelOutput) SetPageinator(v *PageinatorForListModelOutput) *ListModelOutput {
	s.Pageinator = v
	return s
}

type PageinatorForListModelOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Index *int32 `type:"int32" json:"index,omitempty"`

	Size *int32 `type:"int32" json:"size,omitempty"`

	Total_items *int32 `type:"int32" json:"total_items,omitempty"`

	Total_pages *int32 `type:"int32" json:"total_pages,omitempty"`
}

// String returns the string representation
func (s PageinatorForListModelOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageinatorForListModelOutput) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *PageinatorForListModelOutput) SetIndex(v int32) *PageinatorForListModelOutput {
	s.Index = &v
	return s
}

// SetSize sets the Size field's value.
func (s *PageinatorForListModelOutput) SetSize(v int32) *PageinatorForListModelOutput {
	s.Size = &v
	return s
}

// SetTotal_items sets the Total_items field's value.
func (s *PageinatorForListModelOutput) SetTotal_items(v int32) *PageinatorForListModelOutput {
	s.Total_items = &v
	return s
}

// SetTotal_pages sets the Total_pages field's value.
func (s *PageinatorForListModelOutput) SetTotal_pages(v int32) *PageinatorForListModelOutput {
	s.Total_pages = &v
	return s
}

const (
	// EnumOfcreated_orderbyForListModelInput0 is a EnumOfcreated_orderbyForListModelInput enum value
	EnumOfcreated_orderbyForListModelInput0 = "0"

	// EnumOfcreated_orderbyForListModelInput1 is a EnumOfcreated_orderbyForListModelInput enum value
	EnumOfcreated_orderbyForListModelInput1 = "1"
)
