// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package veiapi

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opEdgeCallCommon = "EdgeCall"

// EdgeCallCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the EdgeCallCommon operation. The "output" return
// value will be populated with the EdgeCallCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned EdgeCallCommon Request to send the API call to the service.
// the "output" return value is not valid until after EdgeCallCommon Send returns without error.
//
// See EdgeCallCommon for more information on using the EdgeCallCommon
// API call, and error handling.
//
//    // Example sending a request using the EdgeCallCommonRequest method.
//    req, resp := client.EdgeCallCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) EdgeCallCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opEdgeCallCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// EdgeCallCommon API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation EdgeCallCommon for usage and error information.
func (c *VEIAPI) EdgeCallCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.EdgeCallCommonRequest(input)
	return out, req.Send()
}

// EdgeCallCommonWithContext is the same as EdgeCallCommon with the addition of
// the ability to pass a context and additional request options.
//
// See EdgeCallCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) EdgeCallCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.EdgeCallCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEdgeCall = "EdgeCall"

// EdgeCallRequest generates a "volcengine/request.Request" representing the
// client's request for the EdgeCall operation. The "output" return
// value will be populated with the EdgeCallCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned EdgeCallCommon Request to send the API call to the service.
// the "output" return value is not valid until after EdgeCallCommon Send returns without error.
//
// See EdgeCall for more information on using the EdgeCall
// API call, and error handling.
//
//    // Example sending a request using the EdgeCallRequest method.
//    req, resp := client.EdgeCallRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) EdgeCallRequest(input *EdgeCallInput) (req *request.Request, output *EdgeCallOutput) {
	op := &request.Operation{
		Name:       opEdgeCall,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EdgeCallInput{}
	}

	output = &EdgeCallOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// EdgeCall API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation EdgeCall for usage and error information.
func (c *VEIAPI) EdgeCall(input *EdgeCallInput) (*EdgeCallOutput, error) {
	req, out := c.EdgeCallRequest(input)
	return out, req.Send()
}

// EdgeCallWithContext is the same as EdgeCall with the addition of
// the ability to pass a context and additional request options.
//
// See EdgeCall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) EdgeCallWithContext(ctx volcengine.Context, input *EdgeCallInput, opts ...request.Option) (*EdgeCallOutput, error) {
	req, out := c.EdgeCallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type EdgeCallInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Device_id is a required field
	Device_id *string `type:"string" json:"device_id,omitempty" required:"true"`

	// Function_identifier is a required field
	Function_identifier *string `type:"string" json:"function_identifier,omitempty" required:"true"`

	Input *string `type:"string" json:"input,omitempty"`

	// Mode is a required field
	Mode *int32 `type:"int32" json:"mode,omitempty" required:"true"`

	// Module_identifier is a required field
	Module_identifier *string `type:"string" json:"module_identifier,omitempty" required:"true"`

	Show_template *bool `type:"boolean" json:"show_template,omitempty"`
}

// String returns the string representation
func (s EdgeCallInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EdgeCallInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EdgeCallInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EdgeCallInput"}
	if s.Device_id == nil {
		invalidParams.Add(request.NewErrParamRequired("Device_id"))
	}
	if s.Function_identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Function_identifier"))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.Module_identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Module_identifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevice_id sets the Device_id field's value.
func (s *EdgeCallInput) SetDevice_id(v string) *EdgeCallInput {
	s.Device_id = &v
	return s
}

// SetFunction_identifier sets the Function_identifier field's value.
func (s *EdgeCallInput) SetFunction_identifier(v string) *EdgeCallInput {
	s.Function_identifier = &v
	return s
}

// SetInput sets the Input field's value.
func (s *EdgeCallInput) SetInput(v string) *EdgeCallInput {
	s.Input = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *EdgeCallInput) SetMode(v int32) *EdgeCallInput {
	s.Mode = &v
	return s
}

// SetModule_identifier sets the Module_identifier field's value.
func (s *EdgeCallInput) SetModule_identifier(v string) *EdgeCallInput {
	s.Module_identifier = &v
	return s
}

// SetShow_template sets the Show_template field's value.
func (s *EdgeCallInput) SetShow_template(v bool) *EdgeCallInput {
	s.Show_template = &v
	return s
}

type EdgeCallOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Device_id *string `type:"string" json:"device_id,omitempty"`

	Function_identifier *string `type:"string" json:"function_identifier,omitempty"`

	Mode *int32 `type:"int32" json:"mode,omitempty"`

	Module_identifier *string `type:"string" json:"module_identifier,omitempty"`

	Origin *int64 `type:"int64" json:"origin,omitempty"`

	Output *OutputForEdgeCallOutput `type:"structure" json:"output,omitempty"`

	Template *string `type:"string" json:"template,omitempty"`
}

// String returns the string representation
func (s EdgeCallOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EdgeCallOutput) GoString() string {
	return s.String()
}

// SetDevice_id sets the Device_id field's value.
func (s *EdgeCallOutput) SetDevice_id(v string) *EdgeCallOutput {
	s.Device_id = &v
	return s
}

// SetFunction_identifier sets the Function_identifier field's value.
func (s *EdgeCallOutput) SetFunction_identifier(v string) *EdgeCallOutput {
	s.Function_identifier = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *EdgeCallOutput) SetMode(v int32) *EdgeCallOutput {
	s.Mode = &v
	return s
}

// SetModule_identifier sets the Module_identifier field's value.
func (s *EdgeCallOutput) SetModule_identifier(v string) *EdgeCallOutput {
	s.Module_identifier = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *EdgeCallOutput) SetOrigin(v int64) *EdgeCallOutput {
	s.Origin = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *EdgeCallOutput) SetOutput(v *OutputForEdgeCallOutput) *EdgeCallOutput {
	s.Output = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *EdgeCallOutput) SetTemplate(v string) *EdgeCallOutput {
	s.Template = &v
	return s
}

type OutputForEdgeCallOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Api_version *string `type:"string" json:"api_version,omitempty"`

	Message *string `type:"string" json:"message,omitempty"`

	Reading *ReadingForEdgeCallOutput `type:"structure" json:"reading,omitempty"`

	Status_code *int32 `type:"int32" json:"status_code,omitempty"`
}

// String returns the string representation
func (s OutputForEdgeCallOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputForEdgeCallOutput) GoString() string {
	return s.String()
}

// SetApi_version sets the Api_version field's value.
func (s *OutputForEdgeCallOutput) SetApi_version(v string) *OutputForEdgeCallOutput {
	s.Api_version = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *OutputForEdgeCallOutput) SetMessage(v string) *OutputForEdgeCallOutput {
	s.Message = &v
	return s
}

// SetReading sets the Reading field's value.
func (s *OutputForEdgeCallOutput) SetReading(v *ReadingForEdgeCallOutput) *OutputForEdgeCallOutput {
	s.Reading = v
	return s
}

// SetStatus_code sets the Status_code field's value.
func (s *OutputForEdgeCallOutput) SetStatus_code(v int32) *OutputForEdgeCallOutput {
	s.Status_code = &v
	return s
}

type ReadingForEdgeCallOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:"id,omitempty"`

	Origin *int64 `type:"int64" json:"origin,omitempty"`

	Type *string `type:"string" json:"type,omitempty"`

	Value *string `type:"string" json:"value,omitempty"`
}

// String returns the string representation
func (s ReadingForEdgeCallOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadingForEdgeCallOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ReadingForEdgeCallOutput) SetId(v string) *ReadingForEdgeCallOutput {
	s.Id = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *ReadingForEdgeCallOutput) SetOrigin(v int64) *ReadingForEdgeCallOutput {
	s.Origin = &v
	return s
}

// SetType sets the Type field's value.
func (s *ReadingForEdgeCallOutput) SetType(v string) *ReadingForEdgeCallOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ReadingForEdgeCallOutput) SetValue(v string) *ReadingForEdgeCallOutput {
	s.Value = &v
	return s
}
