// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vefaas

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateFunctionCommon = "CreateFunction"

// CreateFunctionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateFunctionCommon operation. The "output" return
// value will be populated with the CreateFunctionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateFunctionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateFunctionCommon Send returns without error.
//
// See CreateFunctionCommon for more information on using the CreateFunctionCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateFunctionCommonRequest method.
//    req, resp := client.CreateFunctionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEFAAS) CreateFunctionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateFunctionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateFunctionCommon API operation for VEFAAS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEFAAS's
// API operation CreateFunctionCommon for usage and error information.
func (c *VEFAAS) CreateFunctionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateFunctionCommonRequest(input)
	return out, req.Send()
}

// CreateFunctionCommonWithContext is the same as CreateFunctionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunctionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEFAAS) CreateFunctionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateFunctionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateFunction operation. The "output" return
// value will be populated with the CreateFunctionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateFunctionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateFunctionCommon Send returns without error.
//
// See CreateFunction for more information on using the CreateFunction
// API call, and error handling.
//
//    // Example sending a request using the CreateFunctionRequest method.
//    req, resp := client.CreateFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEFAAS) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *CreateFunctionOutput) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	output = &CreateFunctionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateFunction API operation for VEFAAS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEFAAS's
// API operation CreateFunction for usage and error information.
func (c *VEFAAS) CreateFunction(input *CreateFunctionInput) (*CreateFunctionOutput, error) {
	req, out := c.CreateFunctionRequest(input)
	return out, req.Send()
}

// CreateFunctionWithContext is the same as CreateFunction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEFAAS) CreateFunctionWithContext(ctx volcengine.Context, input *CreateFunctionInput, opts ...request.Option) (*CreateFunctionOutput, error) {
	req, out := c.CreateFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cell *string `type:"string" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	CpuMilli *int32 `type:"int32" json:",omitempty"`

	CpuStrategy *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Envs []*EnvForCreateFunctionInput `type:"list" json:",omitempty"`

	ExclusiveMode *bool `type:"boolean" json:",omitempty"`

	InitializerSec *int32 `type:"int32" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty"`

	MaxConcurrency *int32 `type:"int32" json:",omitempty"`

	MemoryMB *int32 `type:"int32" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	NasStorage *NasStorageForCreateFunctionInput `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RequestTimeout *int32 `type:"int32" json:",omitempty"`

	// Runtime is a required field
	Runtime *string `type:"string" json:",omitempty" required:"true"`

	Source *string `type:"string" json:",omitempty"`

	SourceAccessConfig *SourceAccessConfigForCreateFunctionInput `type:"structure" json:",omitempty"`

	SourceType *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateFunctionInput `type:"list" json:",omitempty"`

	TlsConfig *TlsConfigForCreateFunctionInput `type:"structure" json:",omitempty"`

	TosMountConfig *TosMountConfigForCreateFunctionInput `type:"structure" json:",omitempty"`

	VpcConfig *VpcConfigForCreateFunctionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCell sets the Cell field's value.
func (s *CreateFunctionInput) SetCell(v string) *CreateFunctionInput {
	s.Cell = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *CreateFunctionInput) SetCommand(v string) *CreateFunctionInput {
	s.Command = &v
	return s
}

// SetCpuMilli sets the CpuMilli field's value.
func (s *CreateFunctionInput) SetCpuMilli(v int32) *CreateFunctionInput {
	s.CpuMilli = &v
	return s
}

// SetCpuStrategy sets the CpuStrategy field's value.
func (s *CreateFunctionInput) SetCpuStrategy(v string) *CreateFunctionInput {
	s.CpuStrategy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFunctionInput) SetDescription(v string) *CreateFunctionInput {
	s.Description = &v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *CreateFunctionInput) SetEnvs(v []*EnvForCreateFunctionInput) *CreateFunctionInput {
	s.Envs = v
	return s
}

// SetExclusiveMode sets the ExclusiveMode field's value.
func (s *CreateFunctionInput) SetExclusiveMode(v bool) *CreateFunctionInput {
	s.ExclusiveMode = &v
	return s
}

// SetInitializerSec sets the InitializerSec field's value.
func (s *CreateFunctionInput) SetInitializerSec(v int32) *CreateFunctionInput {
	s.InitializerSec = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateFunctionInput) SetInstanceType(v string) *CreateFunctionInput {
	s.InstanceType = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *CreateFunctionInput) SetMaxConcurrency(v int32) *CreateFunctionInput {
	s.MaxConcurrency = &v
	return s
}

// SetMemoryMB sets the MemoryMB field's value.
func (s *CreateFunctionInput) SetMemoryMB(v int32) *CreateFunctionInput {
	s.MemoryMB = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionInput) SetName(v string) *CreateFunctionInput {
	s.Name = &v
	return s
}

// SetNasStorage sets the NasStorage field's value.
func (s *CreateFunctionInput) SetNasStorage(v *NasStorageForCreateFunctionInput) *CreateFunctionInput {
	s.NasStorage = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateFunctionInput) SetProjectName(v string) *CreateFunctionInput {
	s.ProjectName = &v
	return s
}

// SetRequestTimeout sets the RequestTimeout field's value.
func (s *CreateFunctionInput) SetRequestTimeout(v int32) *CreateFunctionInput {
	s.RequestTimeout = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *CreateFunctionInput) SetRuntime(v string) *CreateFunctionInput {
	s.Runtime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateFunctionInput) SetSource(v string) *CreateFunctionInput {
	s.Source = &v
	return s
}

// SetSourceAccessConfig sets the SourceAccessConfig field's value.
func (s *CreateFunctionInput) SetSourceAccessConfig(v *SourceAccessConfigForCreateFunctionInput) *CreateFunctionInput {
	s.SourceAccessConfig = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateFunctionInput) SetSourceType(v string) *CreateFunctionInput {
	s.SourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFunctionInput) SetTags(v []*TagForCreateFunctionInput) *CreateFunctionInput {
	s.Tags = v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *CreateFunctionInput) SetTlsConfig(v *TlsConfigForCreateFunctionInput) *CreateFunctionInput {
	s.TlsConfig = v
	return s
}

// SetTosMountConfig sets the TosMountConfig field's value.
func (s *CreateFunctionInput) SetTosMountConfig(v *TosMountConfigForCreateFunctionInput) *CreateFunctionInput {
	s.TosMountConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFunctionInput) SetVpcConfig(v *VpcConfigForCreateFunctionInput) *CreateFunctionInput {
	s.VpcConfig = v
	return s
}

type CreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Cell *string `type:"string" json:",omitempty"`

	CodeSize *int32 `type:"int32" json:",omitempty"`

	CodeSizeLimit *int32 `type:"int32" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	CreationTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Envs []*EnvForCreateFunctionOutput `type:"list" json:",omitempty"`

	ExclusiveMode *bool `type:"boolean" json:",omitempty"`

	FunctionType *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	InitializerSec *int32 `type:"int32" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty"`

	LastUpdateTime *string `type:"string" json:",omitempty"`

	MaxConcurrency *int32 `type:"int32" json:",omitempty"`

	MemoryMB *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NasStorage *NasStorageForCreateFunctionOutput `type:"structure" json:",omitempty"`

	Owner *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RequestTimeout *int32 `type:"int32" json:",omitempty"`

	Runtime *string `type:"string" json:",omitempty"`

	SourceLocation *string `type:"string" json:",omitempty"`

	SourceType *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateFunctionOutput `type:"list" json:",omitempty"`

	TlsConfig *TlsConfigForCreateFunctionOutput `type:"structure" json:",omitempty"`

	TosMountConfig *TosMountConfigForCreateFunctionOutput `type:"structure" json:",omitempty"`

	TriggersCount *int32 `type:"int32" json:",omitempty"`

	VpcConfig *VpcConfigForCreateFunctionOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionOutput) GoString() string {
	return s.String()
}

// SetCell sets the Cell field's value.
func (s *CreateFunctionOutput) SetCell(v string) *CreateFunctionOutput {
	s.Cell = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *CreateFunctionOutput) SetCodeSize(v int32) *CreateFunctionOutput {
	s.CodeSize = &v
	return s
}

// SetCodeSizeLimit sets the CodeSizeLimit field's value.
func (s *CreateFunctionOutput) SetCodeSizeLimit(v int32) *CreateFunctionOutput {
	s.CodeSizeLimit = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *CreateFunctionOutput) SetCommand(v string) *CreateFunctionOutput {
	s.Command = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateFunctionOutput) SetCreationTime(v string) *CreateFunctionOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFunctionOutput) SetDescription(v string) *CreateFunctionOutput {
	s.Description = &v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *CreateFunctionOutput) SetEnvs(v []*EnvForCreateFunctionOutput) *CreateFunctionOutput {
	s.Envs = v
	return s
}

// SetExclusiveMode sets the ExclusiveMode field's value.
func (s *CreateFunctionOutput) SetExclusiveMode(v bool) *CreateFunctionOutput {
	s.ExclusiveMode = &v
	return s
}

// SetFunctionType sets the FunctionType field's value.
func (s *CreateFunctionOutput) SetFunctionType(v string) *CreateFunctionOutput {
	s.FunctionType = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFunctionOutput) SetId(v string) *CreateFunctionOutput {
	s.Id = &v
	return s
}

// SetInitializerSec sets the InitializerSec field's value.
func (s *CreateFunctionOutput) SetInitializerSec(v int32) *CreateFunctionOutput {
	s.InitializerSec = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateFunctionOutput) SetInstanceType(v string) *CreateFunctionOutput {
	s.InstanceType = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *CreateFunctionOutput) SetLastUpdateTime(v string) *CreateFunctionOutput {
	s.LastUpdateTime = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *CreateFunctionOutput) SetMaxConcurrency(v int32) *CreateFunctionOutput {
	s.MaxConcurrency = &v
	return s
}

// SetMemoryMB sets the MemoryMB field's value.
func (s *CreateFunctionOutput) SetMemoryMB(v int32) *CreateFunctionOutput {
	s.MemoryMB = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionOutput) SetName(v string) *CreateFunctionOutput {
	s.Name = &v
	return s
}

// SetNasStorage sets the NasStorage field's value.
func (s *CreateFunctionOutput) SetNasStorage(v *NasStorageForCreateFunctionOutput) *CreateFunctionOutput {
	s.NasStorage = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *CreateFunctionOutput) SetOwner(v string) *CreateFunctionOutput {
	s.Owner = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateFunctionOutput) SetProjectName(v string) *CreateFunctionOutput {
	s.ProjectName = &v
	return s
}

// SetRequestTimeout sets the RequestTimeout field's value.
func (s *CreateFunctionOutput) SetRequestTimeout(v int32) *CreateFunctionOutput {
	s.RequestTimeout = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *CreateFunctionOutput) SetRuntime(v string) *CreateFunctionOutput {
	s.Runtime = &v
	return s
}

// SetSourceLocation sets the SourceLocation field's value.
func (s *CreateFunctionOutput) SetSourceLocation(v string) *CreateFunctionOutput {
	s.SourceLocation = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateFunctionOutput) SetSourceType(v string) *CreateFunctionOutput {
	s.SourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFunctionOutput) SetTags(v []*TagForCreateFunctionOutput) *CreateFunctionOutput {
	s.Tags = v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *CreateFunctionOutput) SetTlsConfig(v *TlsConfigForCreateFunctionOutput) *CreateFunctionOutput {
	s.TlsConfig = v
	return s
}

// SetTosMountConfig sets the TosMountConfig field's value.
func (s *CreateFunctionOutput) SetTosMountConfig(v *TosMountConfigForCreateFunctionOutput) *CreateFunctionOutput {
	s.TosMountConfig = v
	return s
}

// SetTriggersCount sets the TriggersCount field's value.
func (s *CreateFunctionOutput) SetTriggersCount(v int32) *CreateFunctionOutput {
	s.TriggersCount = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFunctionOutput) SetVpcConfig(v *VpcConfigForCreateFunctionOutput) *CreateFunctionOutput {
	s.VpcConfig = v
	return s
}

type CredentialsForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKeyId *string `type:"string" json:",omitempty"`

	SecretAccessKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialsForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialsForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *CredentialsForCreateFunctionInput) SetAccessKeyId(v string) *CredentialsForCreateFunctionInput {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *CredentialsForCreateFunctionInput) SetSecretAccessKey(v string) *CredentialsForCreateFunctionInput {
	s.SecretAccessKey = &v
	return s
}

type CredentialsForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKeyId *string `type:"string" json:",omitempty"`

	SecretAccessKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialsForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialsForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *CredentialsForCreateFunctionOutput) SetAccessKeyId(v string) *CredentialsForCreateFunctionOutput {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *CredentialsForCreateFunctionOutput) SetSecretAccessKey(v string) *CredentialsForCreateFunctionOutput {
	s.SecretAccessKey = &v
	return s
}

type EnvForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *EnvForCreateFunctionInput) SetKey(v string) *EnvForCreateFunctionInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForCreateFunctionInput) SetValue(v string) *EnvForCreateFunctionInput {
	s.Value = &v
	return s
}

type EnvForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *EnvForCreateFunctionOutput) SetKey(v string) *EnvForCreateFunctionOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForCreateFunctionOutput) SetValue(v string) *EnvForCreateFunctionOutput {
	s.Value = &v
	return s
}

type MountPointForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	BucketPath *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	LocalMountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s MountPointForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MountPointForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *MountPointForCreateFunctionInput) SetBucketName(v string) *MountPointForCreateFunctionInput {
	s.BucketName = &v
	return s
}

// SetBucketPath sets the BucketPath field's value.
func (s *MountPointForCreateFunctionInput) SetBucketPath(v string) *MountPointForCreateFunctionInput {
	s.BucketPath = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *MountPointForCreateFunctionInput) SetEndpoint(v string) *MountPointForCreateFunctionInput {
	s.Endpoint = &v
	return s
}

// SetLocalMountPath sets the LocalMountPath field's value.
func (s *MountPointForCreateFunctionInput) SetLocalMountPath(v string) *MountPointForCreateFunctionInput {
	s.LocalMountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *MountPointForCreateFunctionInput) SetReadOnly(v bool) *MountPointForCreateFunctionInput {
	s.ReadOnly = &v
	return s
}

type MountPointForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	BucketPath *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	LocalMountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s MountPointForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MountPointForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *MountPointForCreateFunctionOutput) SetBucketName(v string) *MountPointForCreateFunctionOutput {
	s.BucketName = &v
	return s
}

// SetBucketPath sets the BucketPath field's value.
func (s *MountPointForCreateFunctionOutput) SetBucketPath(v string) *MountPointForCreateFunctionOutput {
	s.BucketPath = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *MountPointForCreateFunctionOutput) SetEndpoint(v string) *MountPointForCreateFunctionOutput {
	s.Endpoint = &v
	return s
}

// SetLocalMountPath sets the LocalMountPath field's value.
func (s *MountPointForCreateFunctionOutput) SetLocalMountPath(v string) *MountPointForCreateFunctionOutput {
	s.LocalMountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *MountPointForCreateFunctionOutput) SetReadOnly(v bool) *MountPointForCreateFunctionOutput {
	s.ReadOnly = &v
	return s
}

type NasConfigForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemId *string `type:"string" json:",omitempty"`

	Gid *int64 `type:"int64" json:",omitempty"`

	LocalMountPath *string `type:"string" json:",omitempty"`

	MountPointId *string `type:"string" json:",omitempty"`

	RemotePath *string `type:"string" json:",omitempty"`

	Uid *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s NasConfigForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasConfigForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *NasConfigForCreateFunctionInput) SetFileSystemId(v string) *NasConfigForCreateFunctionInput {
	s.FileSystemId = &v
	return s
}

// SetGid sets the Gid field's value.
func (s *NasConfigForCreateFunctionInput) SetGid(v int64) *NasConfigForCreateFunctionInput {
	s.Gid = &v
	return s
}

// SetLocalMountPath sets the LocalMountPath field's value.
func (s *NasConfigForCreateFunctionInput) SetLocalMountPath(v string) *NasConfigForCreateFunctionInput {
	s.LocalMountPath = &v
	return s
}

// SetMountPointId sets the MountPointId field's value.
func (s *NasConfigForCreateFunctionInput) SetMountPointId(v string) *NasConfigForCreateFunctionInput {
	s.MountPointId = &v
	return s
}

// SetRemotePath sets the RemotePath field's value.
func (s *NasConfigForCreateFunctionInput) SetRemotePath(v string) *NasConfigForCreateFunctionInput {
	s.RemotePath = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *NasConfigForCreateFunctionInput) SetUid(v int64) *NasConfigForCreateFunctionInput {
	s.Uid = &v
	return s
}

type NasConfigForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemId *string `type:"string" json:",omitempty"`

	Gid *int64 `type:"int64" json:",omitempty"`

	LocalMountPath *string `type:"string" json:",omitempty"`

	MountPointId *string `type:"string" json:",omitempty"`

	RemotePath *string `type:"string" json:",omitempty"`

	Uid *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s NasConfigForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasConfigForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *NasConfigForCreateFunctionOutput) SetFileSystemId(v string) *NasConfigForCreateFunctionOutput {
	s.FileSystemId = &v
	return s
}

// SetGid sets the Gid field's value.
func (s *NasConfigForCreateFunctionOutput) SetGid(v int64) *NasConfigForCreateFunctionOutput {
	s.Gid = &v
	return s
}

// SetLocalMountPath sets the LocalMountPath field's value.
func (s *NasConfigForCreateFunctionOutput) SetLocalMountPath(v string) *NasConfigForCreateFunctionOutput {
	s.LocalMountPath = &v
	return s
}

// SetMountPointId sets the MountPointId field's value.
func (s *NasConfigForCreateFunctionOutput) SetMountPointId(v string) *NasConfigForCreateFunctionOutput {
	s.MountPointId = &v
	return s
}

// SetRemotePath sets the RemotePath field's value.
func (s *NasConfigForCreateFunctionOutput) SetRemotePath(v string) *NasConfigForCreateFunctionOutput {
	s.RemotePath = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *NasConfigForCreateFunctionOutput) SetUid(v int64) *NasConfigForCreateFunctionOutput {
	s.Uid = &v
	return s
}

type NasStorageForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableNas *bool `type:"boolean" json:",omitempty"`

	NasConfigs []*NasConfigForCreateFunctionInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s NasStorageForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasStorageForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetEnableNas sets the EnableNas field's value.
func (s *NasStorageForCreateFunctionInput) SetEnableNas(v bool) *NasStorageForCreateFunctionInput {
	s.EnableNas = &v
	return s
}

// SetNasConfigs sets the NasConfigs field's value.
func (s *NasStorageForCreateFunctionInput) SetNasConfigs(v []*NasConfigForCreateFunctionInput) *NasStorageForCreateFunctionInput {
	s.NasConfigs = v
	return s
}

type NasStorageForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableNas *bool `type:"boolean" json:",omitempty"`

	NasConfigs []*NasConfigForCreateFunctionOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s NasStorageForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasStorageForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetEnableNas sets the EnableNas field's value.
func (s *NasStorageForCreateFunctionOutput) SetEnableNas(v bool) *NasStorageForCreateFunctionOutput {
	s.EnableNas = &v
	return s
}

// SetNasConfigs sets the NasConfigs field's value.
func (s *NasStorageForCreateFunctionOutput) SetNasConfigs(v []*NasConfigForCreateFunctionOutput) *NasStorageForCreateFunctionOutput {
	s.NasConfigs = v
	return s
}

type SourceAccessConfigForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Password *string `type:"string" json:",omitempty"`

	Username *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SourceAccessConfigForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceAccessConfigForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *SourceAccessConfigForCreateFunctionInput) SetPassword(v string) *SourceAccessConfigForCreateFunctionInput {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *SourceAccessConfigForCreateFunctionInput) SetUsername(v string) *SourceAccessConfigForCreateFunctionInput {
	s.Username = &v
	return s
}

type TagForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateFunctionInput) SetKey(v string) *TagForCreateFunctionInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateFunctionInput) SetValue(v string) *TagForCreateFunctionInput {
	s.Value = &v
	return s
}

type TagForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateFunctionOutput) SetKey(v string) *TagForCreateFunctionOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateFunctionOutput) SetValue(v string) *TagForCreateFunctionOutput {
	s.Value = &v
	return s
}

type TlsConfigForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableLog *bool `type:"boolean" json:",omitempty"`

	TlsProjectId *string `type:"string" json:",omitempty"`

	TlsTopicId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TlsConfigForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsConfigForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetEnableLog sets the EnableLog field's value.
func (s *TlsConfigForCreateFunctionInput) SetEnableLog(v bool) *TlsConfigForCreateFunctionInput {
	s.EnableLog = &v
	return s
}

// SetTlsProjectId sets the TlsProjectId field's value.
func (s *TlsConfigForCreateFunctionInput) SetTlsProjectId(v string) *TlsConfigForCreateFunctionInput {
	s.TlsProjectId = &v
	return s
}

// SetTlsTopicId sets the TlsTopicId field's value.
func (s *TlsConfigForCreateFunctionInput) SetTlsTopicId(v string) *TlsConfigForCreateFunctionInput {
	s.TlsTopicId = &v
	return s
}

type TlsConfigForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableLog *bool `type:"boolean" json:",omitempty"`

	TlsProjectId *string `type:"string" json:",omitempty"`

	TlsTopicId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TlsConfigForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsConfigForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetEnableLog sets the EnableLog field's value.
func (s *TlsConfigForCreateFunctionOutput) SetEnableLog(v bool) *TlsConfigForCreateFunctionOutput {
	s.EnableLog = &v
	return s
}

// SetTlsProjectId sets the TlsProjectId field's value.
func (s *TlsConfigForCreateFunctionOutput) SetTlsProjectId(v string) *TlsConfigForCreateFunctionOutput {
	s.TlsProjectId = &v
	return s
}

// SetTlsTopicId sets the TlsTopicId field's value.
func (s *TlsConfigForCreateFunctionOutput) SetTlsTopicId(v string) *TlsConfigForCreateFunctionOutput {
	s.TlsTopicId = &v
	return s
}

type TosMountConfigForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credentials *CredentialsForCreateFunctionInput `type:"structure" json:",omitempty"`

	EnableTos *bool `type:"boolean" json:",omitempty"`

	MountPoints []*MountPointForCreateFunctionInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TosMountConfigForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosMountConfigForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *TosMountConfigForCreateFunctionInput) SetCredentials(v *CredentialsForCreateFunctionInput) *TosMountConfigForCreateFunctionInput {
	s.Credentials = v
	return s
}

// SetEnableTos sets the EnableTos field's value.
func (s *TosMountConfigForCreateFunctionInput) SetEnableTos(v bool) *TosMountConfigForCreateFunctionInput {
	s.EnableTos = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *TosMountConfigForCreateFunctionInput) SetMountPoints(v []*MountPointForCreateFunctionInput) *TosMountConfigForCreateFunctionInput {
	s.MountPoints = v
	return s
}

type TosMountConfigForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credentials *CredentialsForCreateFunctionOutput `type:"structure" json:",omitempty"`

	EnableTos *bool `type:"boolean" json:",omitempty"`

	MountPoints []*MountPointForCreateFunctionOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TosMountConfigForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosMountConfigForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *TosMountConfigForCreateFunctionOutput) SetCredentials(v *CredentialsForCreateFunctionOutput) *TosMountConfigForCreateFunctionOutput {
	s.Credentials = v
	return s
}

// SetEnableTos sets the EnableTos field's value.
func (s *TosMountConfigForCreateFunctionOutput) SetEnableTos(v bool) *TosMountConfigForCreateFunctionOutput {
	s.EnableTos = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *TosMountConfigForCreateFunctionOutput) SetMountPoints(v []*MountPointForCreateFunctionOutput) *TosMountConfigForCreateFunctionOutput {
	s.MountPoints = v
	return s
}

type VpcConfigForCreateFunctionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableSharedInternetAccess *bool `type:"boolean" json:",omitempty"`

	EnableVpc *bool `type:"boolean" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VpcConfigForCreateFunctionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigForCreateFunctionInput) GoString() string {
	return s.String()
}

// SetEnableSharedInternetAccess sets the EnableSharedInternetAccess field's value.
func (s *VpcConfigForCreateFunctionInput) SetEnableSharedInternetAccess(v bool) *VpcConfigForCreateFunctionInput {
	s.EnableSharedInternetAccess = &v
	return s
}

// SetEnableVpc sets the EnableVpc field's value.
func (s *VpcConfigForCreateFunctionInput) SetEnableVpc(v bool) *VpcConfigForCreateFunctionInput {
	s.EnableVpc = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigForCreateFunctionInput) SetSecurityGroupIds(v []*string) *VpcConfigForCreateFunctionInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigForCreateFunctionInput) SetSubnetIds(v []*string) *VpcConfigForCreateFunctionInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigForCreateFunctionInput) SetVpcId(v string) *VpcConfigForCreateFunctionInput {
	s.VpcId = &v
	return s
}

type VpcConfigForCreateFunctionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableSharedInternetAccess *bool `type:"boolean" json:",omitempty"`

	EnableVpc *bool `type:"boolean" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VpcConfigForCreateFunctionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigForCreateFunctionOutput) GoString() string {
	return s.String()
}

// SetEnableSharedInternetAccess sets the EnableSharedInternetAccess field's value.
func (s *VpcConfigForCreateFunctionOutput) SetEnableSharedInternetAccess(v bool) *VpcConfigForCreateFunctionOutput {
	s.EnableSharedInternetAccess = &v
	return s
}

// SetEnableVpc sets the EnableVpc field's value.
func (s *VpcConfigForCreateFunctionOutput) SetEnableVpc(v bool) *VpcConfigForCreateFunctionOutput {
	s.EnableVpc = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigForCreateFunctionOutput) SetSecurityGroupIds(v []*string) *VpcConfigForCreateFunctionOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigForCreateFunctionOutput) SetSubnetIds(v []*string) *VpcConfigForCreateFunctionOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigForCreateFunctionOutput) SetVpcId(v string) *VpcConfigForCreateFunctionOutput {
	s.VpcId = &v
	return s
}
