// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vedbm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDBInstanceParametersCommon = "DescribeDBInstanceParameters"

// DescribeDBInstanceParametersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceParametersCommon operation. The "output" return
// value will be populated with the DescribeDBInstanceParametersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceParametersCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceParametersCommon Send returns without error.
//
// See DescribeDBInstanceParametersCommon for more information on using the DescribeDBInstanceParametersCommon
// API call, and error handling.
//
//	// Example sending a request using the DescribeDBInstanceParametersCommonRequest method.
//	req, resp := client.DescribeDBInstanceParametersCommonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *VEDBM) DescribeDBInstanceParametersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceParametersCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceParametersCommon API operation for VEDBM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEDBM's
// API operation DescribeDBInstanceParametersCommon for usage and error information.
func (c *VEDBM) DescribeDBInstanceParametersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceParametersCommonRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceParametersCommonWithContext is the same as DescribeDBInstanceParametersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceParametersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEDBM) DescribeDBInstanceParametersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceParametersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBInstanceParameters = "DescribeDBInstanceParameters"

// DescribeDBInstanceParametersRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceParameters operation. The "output" return
// value will be populated with the DescribeDBInstanceParametersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceParametersCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceParametersCommon Send returns without error.
//
// See DescribeDBInstanceParameters for more information on using the DescribeDBInstanceParameters
// API call, and error handling.
//
//	// Example sending a request using the DescribeDBInstanceParametersRequest method.
//	req, resp := client.DescribeDBInstanceParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *VEDBM) DescribeDBInstanceParametersRequest(input *DescribeDBInstanceParametersInput) (req *request.Request, output *DescribeDBInstanceParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBInstanceParametersInput{}
	}

	output = &DescribeDBInstanceParametersOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceParameters API operation for VEDBM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEDBM's
// API operation DescribeDBInstanceParameters for usage and error information.
func (c *VEDBM) DescribeDBInstanceParameters(input *DescribeDBInstanceParametersInput) (*DescribeDBInstanceParametersOutput, error) {
	req, out := c.DescribeDBInstanceParametersRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceParametersWithContext is the same as DescribeDBInstanceParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEDBM) DescribeDBInstanceParametersWithContext(ctx volcengine.Context, input *DescribeDBInstanceParametersInput, opts ...request.Option) (*DescribeDBInstanceParametersOutput, error) {
	req, out := c.DescribeDBInstanceParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeDBInstanceParametersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeDBInstanceParametersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstanceParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstanceParametersInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstanceParametersInput) SetInstanceId(v string) *DescribeDBInstanceParametersInput {
	s.InstanceId = &v
	return s
}

type DescribeDBInstanceParametersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	Parameters []*ParameterForDescribeDBInstanceParametersOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeDBInstanceParametersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceParametersOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstanceParametersOutput) SetInstanceId(v string) *DescribeDBInstanceParametersOutput {
	s.InstanceId = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBInstanceParametersOutput) SetParameters(v []*ParameterForDescribeDBInstanceParametersOutput) *DescribeDBInstanceParametersOutput {
	s.Parameters = v
	return s
}

type ParameterForDescribeDBInstanceParametersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CheckingCode *string `type:"string" json:",omitempty"`

	DataType *string `type:"string" json:",omitempty" enum:"EnumOfDataTypeForDescribeDBInstanceParametersOutput"`

	Modifiable *bool `type:"boolean" json:",omitempty"`

	NeedRestart *bool `type:"boolean" json:",omitempty"`

	ParameterDefaultValue *string `type:"string" json:",omitempty"`

	ParameterDescription *string `type:"string" json:",omitempty"`

	ParameterDisplayValue *string `type:"string" json:",omitempty"`

	ParameterName *string `type:"string" json:",omitempty"`

	ParameterValue *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForDescribeDBInstanceParametersOutput"`
}

// String returns the string representation
func (s ParameterForDescribeDBInstanceParametersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterForDescribeDBInstanceParametersOutput) GoString() string {
	return s.String()
}

// SetCheckingCode sets the CheckingCode field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetCheckingCode(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.CheckingCode = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetDataType(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.DataType = &v
	return s
}

// SetModifiable sets the Modifiable field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetModifiable(v bool) *ParameterForDescribeDBInstanceParametersOutput {
	s.Modifiable = &v
	return s
}

// SetNeedRestart sets the NeedRestart field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetNeedRestart(v bool) *ParameterForDescribeDBInstanceParametersOutput {
	s.NeedRestart = &v
	return s
}

// SetParameterDefaultValue sets the ParameterDefaultValue field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetParameterDefaultValue(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.ParameterDefaultValue = &v
	return s
}

// SetParameterDescription sets the ParameterDescription field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetParameterDescription(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.ParameterDescription = &v
	return s
}

// SetParameterDisplayValue sets the ParameterDisplayValue field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetParameterDisplayValue(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.ParameterDisplayValue = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetParameterName(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetParameterValue(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.ParameterValue = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ParameterForDescribeDBInstanceParametersOutput) SetStatus(v string) *ParameterForDescribeDBInstanceParametersOutput {
	s.Status = &v
	return s
}

const (
	// EnumOfDataTypeForDescribeDBInstanceParametersOutputFloat is a EnumOfDataTypeForDescribeDBInstanceParametersOutput enum value
	EnumOfDataTypeForDescribeDBInstanceParametersOutputFloat = "FLOAT"

	// EnumOfDataTypeForDescribeDBInstanceParametersOutputInt is a EnumOfDataTypeForDescribeDBInstanceParametersOutput enum value
	EnumOfDataTypeForDescribeDBInstanceParametersOutputInt = "INT"

	// EnumOfDataTypeForDescribeDBInstanceParametersOutputString is a EnumOfDataTypeForDescribeDBInstanceParametersOutput enum value
	EnumOfDataTypeForDescribeDBInstanceParametersOutputString = "STRING"
)

const (
	// EnumOfStatusForDescribeDBInstanceParametersOutputApplied is a EnumOfStatusForDescribeDBInstanceParametersOutput enum value
	EnumOfStatusForDescribeDBInstanceParametersOutputApplied = "Applied"

	// EnumOfStatusForDescribeDBInstanceParametersOutputSyncing is a EnumOfStatusForDescribeDBInstanceParametersOutput enum value
	EnumOfStatusForDescribeDBInstanceParametersOutputSyncing = "Syncing"
)
