// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package privatezone

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListRecordSetsCommon = "ListRecordSets"

// ListRecordSetsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRecordSetsCommon operation. The "output" return
// value will be populated with the ListRecordSetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRecordSetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRecordSetsCommon Send returns without error.
//
// See ListRecordSetsCommon for more information on using the ListRecordSetsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListRecordSetsCommonRequest method.
//    req, resp := client.ListRecordSetsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) ListRecordSetsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListRecordSetsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ListRecordSetsCommon API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation ListRecordSetsCommon for usage and error information.
func (c *PRIVATEZONE) ListRecordSetsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListRecordSetsCommonRequest(input)
	return out, req.Send()
}

// ListRecordSetsCommonWithContext is the same as ListRecordSetsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecordSetsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) ListRecordSetsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListRecordSetsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRecordSets = "ListRecordSets"

// ListRecordSetsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRecordSets operation. The "output" return
// value will be populated with the ListRecordSetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRecordSetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRecordSetsCommon Send returns without error.
//
// See ListRecordSets for more information on using the ListRecordSets
// API call, and error handling.
//
//    // Example sending a request using the ListRecordSetsRequest method.
//    req, resp := client.ListRecordSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) ListRecordSetsRequest(input *ListRecordSetsInput) (req *request.Request, output *ListRecordSetsOutput) {
	op := &request.Operation{
		Name:       opListRecordSets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRecordSetsInput{}
	}

	output = &ListRecordSetsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ListRecordSets API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation ListRecordSets for usage and error information.
func (c *PRIVATEZONE) ListRecordSets(input *ListRecordSetsInput) (*ListRecordSetsOutput, error) {
	req, out := c.ListRecordSetsRequest(input)
	return out, req.Send()
}

// ListRecordSetsWithContext is the same as ListRecordSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecordSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) ListRecordSetsWithContext(ctx volcengine.Context, input *ListRecordSetsInput, opts ...request.Option) (*ListRecordSetsOutput, error) {
	req, out := c.ListRecordSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListRecordSetsInput struct {
	_ struct{} `type:"structure"`

	Host *string `type:"string"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	RecordSetID *string `type:"string"`

	SearchMode *string `type:"string"`

	// ZID is a required field
	ZID *int32 `type:"int32" required:"true"`
}

// String returns the string representation
func (s ListRecordSetsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecordSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecordSetsInput"}
	if s.ZID == nil {
		invalidParams.Add(request.NewErrParamRequired("ZID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *ListRecordSetsInput) SetHost(v string) *ListRecordSetsInput {
	s.Host = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRecordSetsInput) SetPageNumber(v int32) *ListRecordSetsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRecordSetsInput) SetPageSize(v int32) *ListRecordSetsInput {
	s.PageSize = &v
	return s
}

// SetRecordSetID sets the RecordSetID field's value.
func (s *ListRecordSetsInput) SetRecordSetID(v string) *ListRecordSetsInput {
	s.RecordSetID = &v
	return s
}

// SetSearchMode sets the SearchMode field's value.
func (s *ListRecordSetsInput) SetSearchMode(v string) *ListRecordSetsInput {
	s.SearchMode = &v
	return s
}

// SetZID sets the ZID field's value.
func (s *ListRecordSetsInput) SetZID(v int32) *ListRecordSetsInput {
	s.ZID = &v
	return s
}

type ListRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	RecordSets []*RecordSetForListRecordSetsOutput `type:"list"`

	TotalCount *int32 `type:"int32"`
}

// String returns the string representation
func (s ListRecordSetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordSetsOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRecordSetsOutput) SetPageNumber(v int32) *ListRecordSetsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRecordSetsOutput) SetPageSize(v int32) *ListRecordSetsOutput {
	s.PageSize = &v
	return s
}

// SetRecordSets sets the RecordSets field's value.
func (s *ListRecordSetsOutput) SetRecordSets(v []*RecordSetForListRecordSetsOutput) *ListRecordSetsOutput {
	s.RecordSets = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListRecordSetsOutput) SetTotalCount(v int32) *ListRecordSetsOutput {
	s.TotalCount = &v
	return s
}

type RecordSetForListRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	FQDN *string `type:"string"`

	Host *string `type:"string"`

	ID *string `type:"string"`

	Line *string `type:"string"`

	Type *string `type:"string"`

	WeightEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s RecordSetForListRecordSetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordSetForListRecordSetsOutput) GoString() string {
	return s.String()
}

// SetFQDN sets the FQDN field's value.
func (s *RecordSetForListRecordSetsOutput) SetFQDN(v string) *RecordSetForListRecordSetsOutput {
	s.FQDN = &v
	return s
}

// SetHost sets the Host field's value.
func (s *RecordSetForListRecordSetsOutput) SetHost(v string) *RecordSetForListRecordSetsOutput {
	s.Host = &v
	return s
}

// SetID sets the ID field's value.
func (s *RecordSetForListRecordSetsOutput) SetID(v string) *RecordSetForListRecordSetsOutput {
	s.ID = &v
	return s
}

// SetLine sets the Line field's value.
func (s *RecordSetForListRecordSetsOutput) SetLine(v string) *RecordSetForListRecordSetsOutput {
	s.Line = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecordSetForListRecordSetsOutput) SetType(v string) *RecordSetForListRecordSetsOutput {
	s.Type = &v
	return s
}

// SetWeightEnabled sets the WeightEnabled field's value.
func (s *RecordSetForListRecordSetsOutput) SetWeightEnabled(v bool) *RecordSetForListRecordSetsOutput {
	s.WeightEnabled = &v
	return s
}
