// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package natgateway

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNatGatewayCommon = "CreateNatGateway"

// CreateNatGatewayCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNatGatewayCommon operation. The "output" return
// value will be populated with the CreateNatGatewayCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNatGatewayCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNatGatewayCommon Send returns without error.
//
// See CreateNatGatewayCommon for more information on using the CreateNatGatewayCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNatGatewayCommonRequest method.
//    req, resp := client.CreateNatGatewayCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *NATGATEWAY) CreateNatGatewayCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNatGatewayCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateNatGatewayCommon API operation for NATGATEWAY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for NATGATEWAY's
// API operation CreateNatGatewayCommon for usage and error information.
func (c *NATGATEWAY) CreateNatGatewayCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNatGatewayCommonRequest(input)
	return out, req.Send()
}

// CreateNatGatewayCommonWithContext is the same as CreateNatGatewayCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNatGatewayCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NATGATEWAY) CreateNatGatewayCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNatGatewayCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNatGateway = "CreateNatGateway"

// CreateNatGatewayRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNatGateway operation. The "output" return
// value will be populated with the CreateNatGatewayCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNatGatewayCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNatGatewayCommon Send returns without error.
//
// See CreateNatGateway for more information on using the CreateNatGateway
// API call, and error handling.
//
//    // Example sending a request using the CreateNatGatewayRequest method.
//    req, resp := client.CreateNatGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *NATGATEWAY) CreateNatGatewayRequest(input *CreateNatGatewayInput) (req *request.Request, output *CreateNatGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateNatGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNatGatewayInput{}
	}

	output = &CreateNatGatewayOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateNatGateway API operation for NATGATEWAY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for NATGATEWAY's
// API operation CreateNatGateway for usage and error information.
func (c *NATGATEWAY) CreateNatGateway(input *CreateNatGatewayInput) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	return out, req.Send()
}

// CreateNatGatewayWithContext is the same as CreateNatGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNatGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NATGATEWAY) CreateNatGatewayWithContext(ctx volcengine.Context, input *CreateNatGatewayInput, opts ...request.Option) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateNatGatewayInput struct {
	_ struct{} `type:"structure"`

	BillingType *int64 `min:"1" max:"3" type:"integer"`

	ClientToken *string `type:"string"`

	Description *string `min:"1" max:"255" type:"string"`

	NatGatewayName *string `min:"1" max:"128" type:"string"`

	Period *int64 `type:"integer"`

	PeriodUnit *string `type:"string"`

	ProjectName *string `type:"string"`

	Spec *string `type:"string"`

	SubnetId *string `type:"string"`

	Tags []*TagForCreateNatGatewayInput `type:"list"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNatGatewayInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNatGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNatGatewayInput"}
	if s.BillingType != nil && *s.BillingType < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BillingType", 1))
	}
	if s.BillingType != nil && *s.BillingType > 3 {
		invalidParams.Add(request.NewErrParamMaxValue("BillingType", 3))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.NatGatewayName != nil && len(*s.NatGatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NatGatewayName", 1))
	}
	if s.NatGatewayName != nil && len(*s.NatGatewayName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("NatGatewayName", 128, *s.NatGatewayName))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingType sets the BillingType field's value.
func (s *CreateNatGatewayInput) SetBillingType(v int64) *CreateNatGatewayInput {
	s.BillingType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNatGatewayInput) SetClientToken(v string) *CreateNatGatewayInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNatGatewayInput) SetDescription(v string) *CreateNatGatewayInput {
	s.Description = &v
	return s
}

// SetNatGatewayName sets the NatGatewayName field's value.
func (s *CreateNatGatewayInput) SetNatGatewayName(v string) *CreateNatGatewayInput {
	s.NatGatewayName = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CreateNatGatewayInput) SetPeriod(v int64) *CreateNatGatewayInput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *CreateNatGatewayInput) SetPeriodUnit(v string) *CreateNatGatewayInput {
	s.PeriodUnit = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateNatGatewayInput) SetProjectName(v string) *CreateNatGatewayInput {
	s.ProjectName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateNatGatewayInput) SetSpec(v string) *CreateNatGatewayInput {
	s.Spec = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateNatGatewayInput) SetSubnetId(v string) *CreateNatGatewayInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNatGatewayInput) SetTags(v []*TagForCreateNatGatewayInput) *CreateNatGatewayInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateNatGatewayInput) SetVpcId(v string) *CreateNatGatewayInput {
	s.VpcId = &v
	return s
}

type CreateNatGatewayOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	NatGatewayId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateNatGatewayOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNatGatewayOutput) GoString() string {
	return s.String()
}

// SetNatGatewayId sets the NatGatewayId field's value.
func (s *CreateNatGatewayOutput) SetNatGatewayId(v string) *CreateNatGatewayOutput {
	s.NatGatewayId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateNatGatewayOutput) SetRequestId(v string) *CreateNatGatewayOutput {
	s.RequestId = &v
	return s
}

type TagForCreateNatGatewayInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateNatGatewayInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateNatGatewayInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateNatGatewayInput) SetKey(v string) *TagForCreateNatGatewayInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateNatGatewayInput) SetValue(v string) *TagForCreateNatGatewayInput {
	s.Value = &v
	return s
}
