// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListJobInstancesCommon = "ListJobInstances"

// ListJobInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListJobInstancesCommon operation. The "output" return
// value will be populated with the ListJobInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListJobInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListJobInstancesCommon Send returns without error.
//
// See ListJobInstancesCommon for more information on using the ListJobInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListJobInstancesCommonRequest method.
//    req, resp := client.ListJobInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListJobInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListJobInstancesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListJobInstancesCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListJobInstancesCommon for usage and error information.
func (c *MLPLATFORM20240701) ListJobInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListJobInstancesCommonRequest(input)
	return out, req.Send()
}

// ListJobInstancesCommonWithContext is the same as ListJobInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListJobInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListJobInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobInstances = "ListJobInstances"

// ListJobInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListJobInstances operation. The "output" return
// value will be populated with the ListJobInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListJobInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListJobInstancesCommon Send returns without error.
//
// See ListJobInstances for more information on using the ListJobInstances
// API call, and error handling.
//
//    // Example sending a request using the ListJobInstancesRequest method.
//    req, resp := client.ListJobInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListJobInstancesRequest(input *ListJobInstancesInput) (req *request.Request, output *ListJobInstancesOutput) {
	op := &request.Operation{
		Name:       opListJobInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListJobInstancesInput{}
	}

	output = &ListJobInstancesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListJobInstances API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListJobInstances for usage and error information.
func (c *MLPLATFORM20240701) ListJobInstances(input *ListJobInstancesInput) (*ListJobInstancesOutput, error) {
	req, out := c.ListJobInstancesRequest(input)
	return out, req.Send()
}

// ListJobInstancesWithContext is the same as ListJobInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListJobInstancesWithContext(ctx volcengine.Context, input *ListJobInstancesInput, opts ...request.Option) (*ListJobInstancesOutput, error) {
	req, out := c.ListJobInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DebugServerForListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PrivateUrl *string `type:"string" json:",omitempty"`

	PublicUrl *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty" enum:"EnumOfStateForListJobInstancesOutput"`
}

// String returns the string representation
func (s DebugServerForListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DebugServerForListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetPrivateUrl sets the PrivateUrl field's value.
func (s *DebugServerForListJobInstancesOutput) SetPrivateUrl(v string) *DebugServerForListJobInstancesOutput {
	s.PrivateUrl = &v
	return s
}

// SetPublicUrl sets the PublicUrl field's value.
func (s *DebugServerForListJobInstancesOutput) SetPublicUrl(v string) *DebugServerForListJobInstancesOutput {
	s.PublicUrl = &v
	return s
}

// SetState sets the State field's value.
func (s *DebugServerForListJobInstancesOutput) SetState(v string) *DebugServerForListJobInstancesOutput {
	s.State = &v
	return s
}

type FlexibleResourceClaimForListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForListJobInstancesOutput) SetCpu(v float64) *FlexibleResourceClaimForListJobInstancesOutput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForListJobInstancesOutput) SetFamily(v string) *FlexibleResourceClaimForListJobInstancesOutput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForListJobInstancesOutput) SetGpuCount(v float64) *FlexibleResourceClaimForListJobInstancesOutput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForListJobInstancesOutput) SetGpuType(v string) *FlexibleResourceClaimForListJobInstancesOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForListJobInstancesOutput) SetMemoryGiB(v float64) *FlexibleResourceClaimForListJobInstancesOutput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForListJobInstancesOutput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForListJobInstancesOutput {
	s.RdmaEniCount = &v
	return s
}

type IpsForListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HostIp *string `type:"string" json:",omitempty"`

	PrimaryIp *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IpsForListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpsForListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetHostIp sets the HostIp field's value.
func (s *IpsForListJobInstancesOutput) SetHostIp(v string) *IpsForListJobInstancesOutput {
	s.HostIp = &v
	return s
}

// SetPrimaryIp sets the PrimaryIp field's value.
func (s *IpsForListJobInstancesOutput) SetPrimaryIp(v string) *IpsForListJobInstancesOutput {
	s.PrimaryIp = &v
	return s
}

type ItemForListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatedBy *string `type:"string" json:",omitempty"`

	DebugServer *DebugServerForListJobInstancesOutput `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Index *string `type:"string" json:",omitempty"`

	Ips *IpsForListJobInstancesOutput `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ResourceClaim *ResourceClaimForListJobInstancesOutput `type:"structure" json:",omitempty"`

	Status *StatusForListJobInstancesOutput `type:"structure" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListJobInstancesOutput) SetCreateTime(v string) *ItemForListJobInstancesOutput {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ItemForListJobInstancesOutput) SetCreatedBy(v string) *ItemForListJobInstancesOutput {
	s.CreatedBy = &v
	return s
}

// SetDebugServer sets the DebugServer field's value.
func (s *ItemForListJobInstancesOutput) SetDebugServer(v *DebugServerForListJobInstancesOutput) *ItemForListJobInstancesOutput {
	s.DebugServer = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListJobInstancesOutput) SetDescription(v string) *ItemForListJobInstancesOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ItemForListJobInstancesOutput) SetId(v string) *ItemForListJobInstancesOutput {
	s.Id = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *ItemForListJobInstancesOutput) SetIndex(v string) *ItemForListJobInstancesOutput {
	s.Index = &v
	return s
}

// SetIps sets the Ips field's value.
func (s *ItemForListJobInstancesOutput) SetIps(v *IpsForListJobInstancesOutput) *ItemForListJobInstancesOutput {
	s.Ips = v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListJobInstancesOutput) SetName(v string) *ItemForListJobInstancesOutput {
	s.Name = &v
	return s
}

// SetResourceClaim sets the ResourceClaim field's value.
func (s *ItemForListJobInstancesOutput) SetResourceClaim(v *ResourceClaimForListJobInstancesOutput) *ItemForListJobInstancesOutput {
	s.ResourceClaim = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListJobInstancesOutput) SetStatus(v *StatusForListJobInstancesOutput) *ItemForListJobInstancesOutput {
	s.Status = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListJobInstancesOutput) SetUpdateTime(v string) *ItemForListJobInstancesOutput {
	s.UpdateTime = &v
	return s
}

type ListJobInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceIds []*string `type:"list" json:",omitempty"`

	// JobId is a required field
	JobId *string `type:"string" json:",omitempty" required:"true"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"10" max:"100" type:"int32" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListJobInstancesInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListJobInstancesInput"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListJobInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobInstancesInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.PageSize != nil && *s.PageSize < 10 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 10))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *ListJobInstancesInput) SetInstanceIds(v []*string) *ListJobInstancesInput {
	s.InstanceIds = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListJobInstancesInput) SetJobId(v string) *ListJobInstancesInput {
	s.JobId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListJobInstancesInput) SetPageNumber(v int32) *ListJobInstancesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListJobInstancesInput) SetPageSize(v int32) *ListJobInstancesInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListJobInstancesInput) SetSortBy(v string) *ListJobInstancesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListJobInstancesInput) SetSortOrder(v string) *ListJobInstancesInput {
	s.SortOrder = &v
	return s
}

// SetState sets the State field's value.
func (s *ListJobInstancesInput) SetState(v string) *ListJobInstancesInput {
	s.State = &v
	return s
}

type ListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListJobInstancesOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListJobInstancesOutput) SetItems(v []*ItemForListJobInstancesOutput) *ListJobInstancesOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListJobInstancesOutput) SetPageNumber(v int32) *ListJobInstancesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListJobInstancesOutput) SetPageSize(v int32) *ListJobInstancesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListJobInstancesOutput) SetTotalCount(v int32) *ListJobInstancesOutput {
	s.TotalCount = &v
	return s
}

type ResourceClaimForListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForListJobInstancesOutput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceClaimForListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceClaimForListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceClaimForListJobInstancesOutput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForListJobInstancesOutput) *ResourceClaimForListJobInstancesOutput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceClaimForListJobInstancesOutput) SetInstanceTypeId(v string) *ResourceClaimForListJobInstancesOutput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceClaimForListJobInstancesOutput) SetType(v string) *ResourceClaimForListJobInstancesOutput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceClaimForListJobInstancesOutput) SetZoneId(v string) *ResourceClaimForListJobInstancesOutput {
	s.ZoneId = &v
	return s
}

type StatusForListJobInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DiagnoseMessage *string `type:"string" json:",omitempty"`

	DiagnoseState *string `type:"string" json:",omitempty" enum:"EnumOfDiagnoseStateForListJobInstancesOutput"`

	EndTime *string `type:"string" json:",omitempty"`

	ExitCode *int32 `type:"int32" json:",omitempty"`

	HoldingEndTime *string `type:"string" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	NumaStatus *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty" enum:"EnumOfSecondaryStateForListJobInstancesOutput"`

	StartTime *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty" enum:"ConvertEnumOfStateForListJobInstancesOutput"`
}

// String returns the string representation
func (s StatusForListJobInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListJobInstancesOutput) GoString() string {
	return s.String()
}

// SetDiagnoseMessage sets the DiagnoseMessage field's value.
func (s *StatusForListJobInstancesOutput) SetDiagnoseMessage(v string) *StatusForListJobInstancesOutput {
	s.DiagnoseMessage = &v
	return s
}

// SetDiagnoseState sets the DiagnoseState field's value.
func (s *StatusForListJobInstancesOutput) SetDiagnoseState(v string) *StatusForListJobInstancesOutput {
	s.DiagnoseState = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *StatusForListJobInstancesOutput) SetEndTime(v string) *StatusForListJobInstancesOutput {
	s.EndTime = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *StatusForListJobInstancesOutput) SetExitCode(v int32) *StatusForListJobInstancesOutput {
	s.ExitCode = &v
	return s
}

// SetHoldingEndTime sets the HoldingEndTime field's value.
func (s *StatusForListJobInstancesOutput) SetHoldingEndTime(v string) *StatusForListJobInstancesOutput {
	s.HoldingEndTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *StatusForListJobInstancesOutput) SetMessage(v string) *StatusForListJobInstancesOutput {
	s.Message = &v
	return s
}

// SetNumaStatus sets the NumaStatus field's value.
func (s *StatusForListJobInstancesOutput) SetNumaStatus(v string) *StatusForListJobInstancesOutput {
	s.NumaStatus = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForListJobInstancesOutput) SetSecondaryState(v string) *StatusForListJobInstancesOutput {
	s.SecondaryState = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StatusForListJobInstancesOutput) SetStartTime(v string) *StatusForListJobInstancesOutput {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForListJobInstancesOutput) SetState(v string) *StatusForListJobInstancesOutput {
	s.State = &v
	return s
}

const (
	// ConvertEnumOfStateForListJobInstancesOutputQueueing is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputQueueing = "Queueing"

	// ConvertEnumOfStateForListJobInstancesOutputDeploying is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputDeploying = "Deploying"

	// ConvertEnumOfStateForListJobInstancesOutputRunning is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputRunning = "Running"

	// ConvertEnumOfStateForListJobInstancesOutputCompleted is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputCompleted = "Completed"

	// ConvertEnumOfStateForListJobInstancesOutputFailed is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputFailed = "Failed"

	// ConvertEnumOfStateForListJobInstancesOutputStopping is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputStopping = "Stopping"

	// ConvertEnumOfStateForListJobInstancesOutputStopped is a ConvertEnumOfStateForListJobInstancesOutput enum value
	ConvertEnumOfStateForListJobInstancesOutputStopped = "Stopped"
)

const (
	// EnumOfDiagnoseStateForListJobInstancesOutputWaiting is a EnumOfDiagnoseStateForListJobInstancesOutput enum value
	EnumOfDiagnoseStateForListJobInstancesOutputWaiting = "Waiting"

	// EnumOfDiagnoseStateForListJobInstancesOutputRunning is a EnumOfDiagnoseStateForListJobInstancesOutput enum value
	EnumOfDiagnoseStateForListJobInstancesOutputRunning = "Running"

	// EnumOfDiagnoseStateForListJobInstancesOutputPassed is a EnumOfDiagnoseStateForListJobInstancesOutput enum value
	EnumOfDiagnoseStateForListJobInstancesOutputPassed = "Passed"

	// EnumOfDiagnoseStateForListJobInstancesOutputFailed is a EnumOfDiagnoseStateForListJobInstancesOutput enum value
	EnumOfDiagnoseStateForListJobInstancesOutputFailed = "Failed"

	// EnumOfDiagnoseStateForListJobInstancesOutputAbnormal is a EnumOfDiagnoseStateForListJobInstancesOutput enum value
	EnumOfDiagnoseStateForListJobInstancesOutputAbnormal = "Abnormal"
)

const (
	// EnumOfSecondaryStateForListJobInstancesOutputCompletedHolding is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputCompletedHolding = "CompletedHolding"

	// EnumOfSecondaryStateForListJobInstancesOutputFailedHolding is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputFailedHolding = "FailedHolding"

	// EnumOfSecondaryStateForListJobInstancesOutputNodeWentDown is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputNodeWentDown = "NodeWentDown"

	// EnumOfSecondaryStateForListJobInstancesOutputMachineFault is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputMachineFault = "MachineFault"

	// EnumOfSecondaryStateForListJobInstancesOutputMachineSuspected is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputMachineSuspected = "MachineSuspected"

	// EnumOfSecondaryStateForListJobInstancesOutputMachineRegular is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputMachineRegular = "MachineRegular"

	// EnumOfSecondaryStateForListJobInstancesOutputPodOomkilled is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputPodOomkilled = "PodOOMKilled"

	// EnumOfSecondaryStateForListJobInstancesOutputPodReclaimed is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputPodReclaimed = "PodReclaimed"

	// EnumOfSecondaryStateForListJobInstancesOutputPodAutoGpucompacted is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputPodAutoGpucompacted = "PodAutoGPUCompacted"

	// EnumOfSecondaryStateForListJobInstancesOutputPodEvictByQos is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputPodEvictByQos = "PodEvictByQOS"

	// EnumOfSecondaryStateForListJobInstancesOutputPodEvictByGpupreemptCpu is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputPodEvictByGpupreemptCpu = "PodEvictByGPUPreemptCPU"

	// EnumOfSecondaryStateForListJobInstancesOutputDiagnosisEnvDiagFailed is a EnumOfSecondaryStateForListJobInstancesOutput enum value
	EnumOfSecondaryStateForListJobInstancesOutputDiagnosisEnvDiagFailed = "DiagnosisEnvDiagFailed"
)

const (
	// EnumOfSortByForListJobInstancesInputCreateTime is a EnumOfSortByForListJobInstancesInput enum value
	EnumOfSortByForListJobInstancesInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForListJobInstancesInputAscend is a EnumOfSortOrderForListJobInstancesInput enum value
	EnumOfSortOrderForListJobInstancesInputAscend = "Ascend"

	// EnumOfSortOrderForListJobInstancesInputDescend is a EnumOfSortOrderForListJobInstancesInput enum value
	EnumOfSortOrderForListJobInstancesInputDescend = "Descend"
)

const (
	// EnumOfStateForListJobInstancesOutputDeploying is a EnumOfStateForListJobInstancesOutput enum value
	EnumOfStateForListJobInstancesOutputDeploying = "Deploying"

	// EnumOfStateForListJobInstancesOutputRunning is a EnumOfStateForListJobInstancesOutput enum value
	EnumOfStateForListJobInstancesOutputRunning = "Running"
)
